/*
 * Decompiled with CFR 0.152.
 */
package com.instalments.api;

import com.Application;
import com.instalments.domain.InstalmentDto;
import com.instalments.domain.InstalmentService;
import com.instalments.domain.InstalmentSettleDto;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@RequestMapping(value={"/instalment"})
public class InstalmentApi {
    private final Application app;
    private final InstalmentService service;

    @GetMapping
    public ResponseEntity<List<InstalmentDto>> getInstalments(HttpServletRequest request) {
        if (!Application.isAccessWebService || !this.app.usePack2) {
            return null;
        }
        return this.service.getInstalments(request);
    }

    @PutMapping
    public ResponseEntity<Map<String, Object>> settleInstalments(@RequestBody List<InstalmentSettleDto> settleDtoList) {
        if (!Application.isAccessWebService || !this.app.usePack2) {
            return null;
        }
        return this.service.settleInstalments(settleDtoList);
    }

    @ApiIgnore
    @PostMapping
    public ResponseEntity<Map<String, Object>> postSmartHelpInstalments(@RequestBody byte[] zippedBody) {
        if (!Application.isAccessWebService || !this.app.usePack2) {
            return null;
        }
        return this.service.postSmartHelpInstalments(zippedBody);
    }

    public InstalmentApi(Application app, InstalmentService service) {
        this.app = app;
        this.service = service;
    }
}

