/*
 * Decompiled with CFR 0.152.
 */
package com.instalments.domain.use_case;

import com.customer.domain.use_case.GetCustomerCount;
import com.instalments.domain.InstalmentDto;
import com.instalments.domain.InstalmentSettleDto;
import com.instalments.domain.use_case.CheckInstalmentSettleErrors;
import com.instalments.domain.use_case.GetInstalments;
import com.security.SecurityConstants;
import com.service.invoice.CheckPayError;
import com.utility.ConvertStr;
import com.utility.Pair;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class CheckInstalmentSettleErrors {
    private final CheckPayError checkPayError;
    private final GetInstalments getInstalments;
    private final GetCustomerCount getCustomerCount;
    private List<InstalmentDto> instalments;

    public InstalmentCheckErrorResult invoke(InstalmentSettleDto settleDto) throws TncException {
        this.checkDateTime(settleDto);
        if (this.invalidOrSettledIndex(settleDto)) {
            throw new TncException(TncExceptionMessages.INVALID_INSTALMENT_INDEX);
        }
        this.checkPayError.checkAll(CheckPayError.PaymentData.builder().cash(settleDto.getCashNullSafe()).cashHeading(settleDto.getCashHeading()).pos(settleDto.getPosNullSafe()).posHeading(settleDto.getPosHeading()).discount(settleDto.getDiscountNullSafe()).discountHeading(settleDto.getDiscountHeading()).discountType(this.getCurrentInstalment().isOurPayment() ? CheckPayError.SarfaslType.INSTALMENT_PAY_DISCOUNT : CheckPayError.SarfaslType.INSTALMENT_RECEIVE_DISCOUNT).build(), SecurityConstants.loadToken());
        settleDto.setCustomerCode(this.getCurrentInstalment().getCustomerCode());
        if (settleDto.getCustomerCode().length() < 5) {
            throw new TncException(TncExceptionMessages.BANK_SETTLEMENT_CURRENTLY_NOT_ALLOWED);
        }
        Pair pairNotEqualOrAddedToNext = this.paymentAndAmountNotEqual(settleDto);
        if (((Boolean)pairNotEqualOrAddedToNext.getLeft()).booleanValue()) {
            throw new TncException(TncExceptionMessages.UNEVEN_PAY_AND_TO_PAY_PRICES_INSTALMENT);
        }
        if (this.customerNotExist()) {
            throw new TncException(TncExceptionMessages.INVALID_CUSTOMER_CODE.addSuffixes(new Object[]{" : " + settleDto.getCustomerCode()}));
        }
        return new InstalmentCheckErrorResult(((Boolean)pairNotEqualOrAddedToNext.getRight()).booleanValue(), this.getCurrentInstalment());
    }

    private void checkDateTime(InstalmentSettleDto settleDto) {
        if (ConvertStr.isNullOrEmpty((String)settleDto.getSettleDate()) || settleDto.getSettleDate().length() != "2024-01-01".length()) {
            throw new TncException(TncExceptionMessages.INVALID_DATE);
        }
        if (ConvertStr.isNullOrEmpty((String)settleDto.getSettleTime()) || settleDto.getSettleTime().length() < 5) {
            throw new TncException(TncExceptionMessages.INVALID_TIME);
        }
        if (settleDto.getSettleTime().length() > 8) {
            settleDto.setSettleTime(settleDto.getSettleTime().substring(0, 9));
        }
    }

    private boolean invalidOrSettledIndex(InstalmentSettleDto settleDto) {
        this.instalments = this.fetchInstalment(settleDto);
        return this.instalments.isEmpty();
    }

    private Pair<Boolean, Boolean> paymentAndAmountNotEqual(InstalmentSettleDto settleDto) {
        InstalmentDto instalment = this.getCurrentInstalment();
        if (instalment.getToPayAmount() != settleDto.sumAllAmounts()) {
            return new Pair((Object)true, (Object)false);
        }
        return new Pair((Object)false, (Object)false);
    }

    private boolean customerNotExist() {
        String customerCode = this.getCurrentInstalment().getCustomerCode();
        if (ConvertStr.isNullOrEmpty((String)customerCode)) {
            return true;
        }
        return this.getCustomerCount.invoke(ConvertStr.buildMap(map -> map.put("code", customerCode))) == 0;
    }

    private List<InstalmentDto> fetchInstalment(InstalmentSettleDto settleDto) {
        return this.getInstalments.invoke(ConvertStr.buildMap(map -> {
            map.put("index", String.valueOf(settleDto.getIndex()));
            map.put("is-settled", "false");
        }));
    }

    private InstalmentDto getCurrentInstalment() {
        return (InstalmentDto)this.instalments.get(0);
    }

    public CheckInstalmentSettleErrors(CheckPayError checkPayError, GetInstalments getInstalments, GetCustomerCount getCustomerCount) {
        this.checkPayError = checkPayError;
        this.getInstalments = getInstalments;
        this.getCustomerCount = getCustomerCount;
    }
}

