/*
 * Decompiled with CFR 0.152.
 */
package com.instalments.domain.use_case;

import com.dto.PaymentDetailDto;
import com.dto.PaymentDto;
import com.instalments.domain.InstalmentDto;
import com.instalments.domain.InstalmentSettleDto;
import com.utility.ConvertStr;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MakeInstalmentDocDtl {
    private static final String defaultCommentPlaceHolder = "%s \u0642\u0633\u0637 %s";
    private final InstalmentDto currentInstalment;

    public List<PaymentDetailDto> invoke(InstalmentSettleDto settleDto, PaymentDto docData) {
        return ConvertStr.buildList(list -> {
            list.add(this.getMainDocDtl(settleDto, docData));
            if (settleDto.getCashNullSafe() > 0.0) {
                list.add(this.buildCashDocDtl(settleDto, docData));
            }
            if (settleDto.getPosNullSafe() > 0.0) {
                list.add(this.getPosDocDtl(settleDto, docData));
            }
            if (settleDto.getDiscountNullSafe() > 0.0) {
                list.add(this.getDiscountDocDtl(settleDto, docData));
            }
        });
    }

    private PaymentDetailDto getMainDocDtl(InstalmentSettleDto settleDto, PaymentDto docData) {
        String cHeading = docData.getCustomersarfasl();
        return PaymentDetailDto.builder().docCode(settleDto.getDocCode()).colcode(cHeading.substring(0, 3)).moiencode(cHeading.substring(3, 7)).tafzilicode(cHeading.substring(7)).bed(Double.valueOf(this.currentInstalment.isOurPayment() ? settleDto.sumAllAmounts() : 0.0)).bes(Double.valueOf(this.currentInstalment.isOurPayment() ? 0.0 : settleDto.sumAllAmounts())).typeline("S").actions(0).commentline(String.format(defaultCommentPlaceHolder, this.getPayOrReceiveStr(), this.currentInstalment.getInstalmentNumber())).build();
    }

    private PaymentDetailDto buildCashDocDtl(InstalmentSettleDto settleDto, PaymentDto docData) {
        return PaymentDetailDto.builder().docCode(settleDto.getDocCode()).colcode(settleDto.getCashHeading().substring(0, 3)).moiencode(settleDto.getCashHeading().substring(3, 7)).tafzilicode(settleDto.getCashHeading().substring(7)).bed(Double.valueOf(this.currentInstalment.isOurPayment() ? 0.0 : settleDto.getCash())).bes(Double.valueOf(this.currentInstalment.isOurPayment() ? settleDto.getCash() : 0.0)).typeline("Z").actions(0).commentline(String.format(defaultCommentPlaceHolder, this.getPayOrReceiveStr(), docData.getCustomerName())).build();
    }

    private PaymentDetailDto getPosDocDtl(InstalmentSettleDto settleDto, PaymentDto docData) {
        return PaymentDetailDto.builder().docCode(settleDto.getDocCode()).colcode(settleDto.getPosHeading().substring(0, 3)).moiencode(settleDto.getPosHeading().substring(3, 7)).tafzilicode(settleDto.getPosHeading().substring(7)).bed(Double.valueOf(this.currentInstalment.isOurPayment() ? 0.0 : settleDto.getPos())).bes(Double.valueOf(this.currentInstalment.isOurPayment() ? settleDto.getPos() : 0.0)).typeline("Z").actions(0).commentline(String.format(defaultCommentPlaceHolder, this.getPayOrReceiveStr(), docData.getCustomerName())).build();
    }

    private PaymentDetailDto getDiscountDocDtl(InstalmentSettleDto settleDto, PaymentDto docData) {
        return PaymentDetailDto.builder().docCode(settleDto.getDocCode()).colcode(settleDto.getDiscountHeading().substring(0, 3)).moiencode(settleDto.getDiscountHeading().substring(3, 7)).tafzilicode(settleDto.getDiscountHeading().substring(7)).bed(Double.valueOf(this.currentInstalment.isOurPayment() ? 0.0 : settleDto.getDiscount())).bes(Double.valueOf(this.currentInstalment.isOurPayment() ? settleDto.getDiscount() : 0.0)).typeline("Z").actions(0).commentline(String.format(defaultCommentPlaceHolder, "\u067e\u0631\u062f\u0627\u062e\u062a", docData.getCustomerName())).build();
    }

    @NotNull
    private String getPayOrReceiveStr() {
        return this.currentInstalment.isOurPayment() ? "\u067e\u0631\u062f\u0627\u062e\u062a" : "\u062f\u0631\u06cc\u0627\u0641\u062a";
    }

    public MakeInstalmentDocDtl(InstalmentDto currentInstalment) {
        this.currentInstalment = currentInstalment;
    }
}

