/*
 * Decompiled with CFR 0.152.
 */
package com.item_article.data;

import com.category.domain.model.ProductCategory;
import com.dao.util.ItemArticleBulkInsert;
import com.dto.ItemArticleDto;
import com.dto.LoginDto;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.GetIdentity;
import com.utility.TncException;
import com.utility.TncJdbc;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Component;

@Component
public class ItemArticleDao {
    private final DbConnection dbConnection;

    @Autowired
    public ItemArticleDao(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }

    public LoginDto setToken() {
        return this.dbConnection.setToken();
    }

    public List<ItemArticleDto> loadAll(String sqlWhere, LoginDto login) {
        String sql = "SELECT id, a_code, poshakID, few, i_min, i_max, poshakId_c \n FROM ItemArticle " + sqlWhere;
        return this.dbConnection.getJdbcTemplate(login).query(sql, (rs, rowNum) -> ItemArticleDto.builder().id(rs.getLong("id")).a_code(rs.getString("a_code")).poshakid(rs.getLong("poshakID")).few(rs.getDouble("few")).min(rs.getDouble("i_min")).max(rs.getDouble("i_max")).poshakidc(Integer.valueOf(rs.getInt("poshakId_c"))).build());
    }

    public int getAttribCountByProductAndPoshakId(String productId, int poshakId, LoginDto login) {
        String sqlStr = " SELECT COUNT(*) CNT FROM ITEMARTICLE WHERE A_CODE='" + productId + "' AND POSHAKID = " + poshakId;
        SqlRowSet rs = this.dbConnection.getJdbcTemplate(login).queryForRowSet(sqlStr);
        rs.next();
        return rs.getInt("CNT");
    }

    public double getAttribFewByProductAndPoshakId(String productId, int poshakId, LoginDto login) {
        String sqlStr = " SELECT FEW FROM ITEMARTICLE WHERE A_CODE='" + productId + "' AND POSHAKID = " + poshakId;
        SqlRowSet rs = this.dbConnection.getJdbcTemplate(login).queryForRowSet(sqlStr);
        rs.next();
        return rs.getDouble("FEW");
    }

    public long insert(@NotNull ItemArticleDto itemArticleDto, LoginDto login) {
        String sqlStr = " INSERT INTO ITEMARTICLE (A_CODE, POSHAKID, FEW, SELECTED, I_MIN, I_MAX, POSHAKID_C)  VALUES(?, ?, ?, ?, ?, ?, ?)";
        TncJdbc jdbc = this.dbConnection.getJdbcTemplate(login);
        jdbc.update(sqlStr, new Object[]{itemArticleDto.getA_code(), itemArticleDto.getPoshakid(), itemArticleDto.getFew(), 0, itemArticleDto.getMin(), itemArticleDto.getMax(), itemArticleDto.getPoshakidc()});
        return GetIdentity.invoke((TncJdbc)jdbc);
    }

    public void bulkInsert(LoginDto loginDto, List<ItemArticleDto> itemArticleList) throws TncException {
        new ItemArticleBulkInsert(this.dbConnection).bulkInsert(loginDto, itemArticleList);
    }

    public void updateItemArticleFew(LoginDto login, @NotNull ProductCategory productCategory, String productId, String operatorChar) {
        String sqlStr = " UPDATE ITEMARTICLE SET FEW = FEW " + operatorChar + productCategory.getFew() + " WHERE A_CODE = '" + productId + "' AND POSHAKID = " + productCategory.getId();
        this.dbConnection.getJdbcTemplate(login).execute(sqlStr);
    }

    public void insertItemFact(LoginDto login, String facCode, String facType, String productId, @NotNull ProductCategory productCategory, int index, boolean fromTmpFacture) {
        String sqlStr = " INSERT INTO ITEMFACT(FAC_CODE,FAC_TYPE,A_CODE,A_INDEX,POSHAKIDF,FEW) SELECT " + (fromTmpFacture ? "'" + facCode + "'" : "DBO.PRODUCCODE(" + facCode + ")") + ",'" + facType + "','" + productId + "'," + index + "," + productCategory.getId() + "," + productCategory.getFew();
        this.dbConnection.getJdbcTemplate(login).execute(sqlStr);
    }

    public void insertItemFact(LoginDto login, String facCode, String facType, String productId, @NotNull ProductCategory productCategory, int index) {
        this.insertItemFact(login, facCode, facType, productId, productCategory, index, false);
    }

    public StringBuilder getAttributeNameTree(@NotNull ProductCategory productCategory, StringBuilder sb, LoginDto login) {
        String sqlStr = "SELECT DBO.GETTREELEVELNAME(" + productCategory.getId() + ") NAME ";
        SqlRowSet rs = this.dbConnection.getJdbcTemplate(login).queryForRowSet(sqlStr);
        while (rs.next()) {
            if (!sb.toString().isEmpty()) {
                sb.append("-");
            }
            sb.append(rs.getString("NAME")).append("*").append(ConvertStr.removeDecimalPartFromDouble((double)productCategory.getFew()));
        }
        return sb;
    }

    public int getExistingPoshakIdC(String aCode, LoginDto login) {
        String sqlStr = "SELECT TOP 1 PoshakID_C FROM ItemArticle WHERE A_CODE = ? ORDER BY PoshakID_C DESC ";
        SqlRowSet rs = this.dbConnection.getJdbcTemplate(login).queryForRowSet(sqlStr, new Object[]{aCode});
        if (rs.next()) {
            return rs.getInt("PoshakID_C");
        }
        return 0;
    }
}

