/*
 * Decompiled with CFR 0.152.
 */
package com.item_article.domain.use_case;

import com.category.domain.use_case.category.GetCategories;
import com.dto.ItemArticleDto;
import com.dto.LoginDto;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
public class CheckItemArticleErrors {
    private final DbConnection dbConnection;
    private final GetCategories getCategories;

    public void invoke(@NotNull ItemArticleDto itemArt, LoginDto login) throws TncException {
        if (itemArt.getMax() < 0.0 || itemArt.getMin() < 0.0 || itemArt.getFew() < 0.0 || ConvertStr.isNullOrEmpty((String)itemArt.getCategories())) {
            throw new TncException(TncExceptionMessages.WRONG_JSON_STRUCT);
        }
        if (ConvertStr.isNullOrEmpty((String)itemArt.getA_code())) {
            throw new TncException(TncExceptionMessages.INVALID_PRODUCT_CODE);
        }
        itemArt.setA_code(ConvertStr.decrypt((String)itemArt.getA_code()));
        this.checkACodeExists(itemArt, login);
        this.checkCategories(itemArt.splitCategories());
    }

    private void checkACodeExists(@NotNull ItemArticleDto itemArt, LoginDto login) {
        boolean nonExistentProduct;
        Integer productCount = (Integer)this.dbConnection.getJdbcTemplate(login).queryForObject("SELECT COUNT(*) cnt FROM ARTICLE WHERE A_CODE = ?", Integer.class, new Object[]{itemArt.getA_code()});
        boolean bl = nonExistentProduct = productCount == null || productCount == 0;
        if (nonExistentProduct) {
            throw new TncException(TncExceptionMessages.INVALID_PRODUCT_CODE);
        }
    }

    private void checkCategories(@NotNull List<String> categories) {
        for (String category2 : categories) {
            try {
                Integer.parseInt(category2);
            }
            catch (NumberFormatException e) {
                throw new TncException(TncExceptionMessages.INVALID_CATEGORY_ID);
            }
        }
        List fetchedCategories = this.getCategories.invokeAsObject(this.makeIdParamMap(categories));
        if (fetchedCategories.isEmpty() || fetchedCategories.size() < categories.size()) {
            throw new TncException(TncExceptionMessages.INVALID_CATEGORY_ID);
        }
        if (fetchedCategories.stream().anyMatch(category -> category.getParentId() == 0L)) {
            throw new TncException(TncExceptionMessages.PARENT_CATEGORIES_FORBIDDEN_FOR_PRODUCT);
        }
    }

    @NotNull
    private Map<String, String[]> makeIdParamMap(List<String> providedIdList) {
        HashMap<String, String[]> paramsMap = new HashMap<String, String[]>();
        paramsMap.put("id", new String[]{ConvertStr.bindStrings(providedIdList, (String)",")});
        return paramsMap;
    }

    public CheckItemArticleErrors(DbConnection dbConnection, GetCategories getCategories) {
        this.dbConnection = dbConnection;
        this.getCategories = getCategories;
    }
}

