/*
 * Decompiled with CFR 0.152.
 */
package com.log;

import com.dto.LoginDto;
import com.log.RequestLog;
import com.utility.DbConnection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Repository;

@Repository
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/log/LogRepository;", "", "dbConnection", "Lcom/utility/DbConnection;", "(Lcom/utility/DbConnection;)V", "saveLoginLog", "", "log", "Lcom/log/RequestLog;", "myLogin", "Lcom/dto/LoginDto;", "saveNoneLoginLog", "TNCHolooWebService"})
public class LogRepository {
    @NotNull
    private final DbConnection dbConnection;

    public LogRepository(@NotNull DbConnection dbConnection) {
        Intrinsics.checkNotNullParameter((Object)dbConnection, (String)"dbConnection");
        this.dbConnection = dbConnection;
    }

    public void saveNoneLoginLog(@NotNull RequestLog log) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        String sql = "INSERT INTO ANDROID_USER_ACTIONS(UserCodeInc, Method, Uri, IP, Status, Duration, [Timestamp], Username) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        Object[] objectArray = new Object[]{log.getUserCodeInc(), log.getMethod(), log.getUri(), log.getIp(), log.getStatus(), log.getDuration(), log.getTimestamp(), log.getUsername()};
        this.dbConnection.getJdbcTemplate().update(sql, objectArray);
    }

    public void saveLoginLog(@NotNull RequestLog log, @NotNull LoginDto myLogin) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)myLogin, (String)"myLogin");
        String sql = "INSERT INTO ANDROID_USER_ACTIONS(UserCodeInc, Method, Uri, IP, Status, Duration, [Timestamp], Username) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        Object[] objectArray = new Object[]{log.getUserCodeInc(), log.getMethod(), log.getUri(), log.getIp(), log.getStatus(), log.getDuration(), log.getTimestamp(), log.getUsername()};
        this.dbConnection.getJdbcTemplate(myLogin).update(sql, objectArray);
    }
}

