/*
 * Decompiled with CFR 0.152.
 */
package com.resource;

import com.Application;
import com.dao.MainGroupDao;
import com.dao.ProductDao;
import com.dao.SideGroupDao;
import com.dao.UnitDao;
import com.dto.product.ProductBuildDto;
import com.dto.transfer.ProductTransferDto;
import com.utility.ConvertStr;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
public class Product {
    private final Application application;
    private final MainGroupDao mainGroupDao;
    private final SideGroupDao sideGroupDao;
    private final UnitDao unitDao;
    private final ProductDao productDao;

    public Product(Application application, MainGroupDao mainGroupDao, SideGroupDao sideGroupDao, UnitDao unitDao, ProductDao productDao) {
        this.application = application;
        this.mainGroupDao = mainGroupDao;
        this.sideGroupDao = sideGroupDao;
        this.unitDao = unitDao;
        this.productDao = productDao;
    }

    @GetMapping(value={"/MainGroup"})
    public ResponseEntity<?> getMainGroup(HttpServletRequest request) {
        if (!Application.isAccessWebService || !this.application.usePack1) {
            return null;
        }
        return this.mainGroupDao.getMainGroupList(request);
    }

    @GetMapping(value={"/SideGroup"})
    public ResponseEntity<?> getSideGroup(HttpServletRequest request) {
        if (!Application.isAccessWebService || !this.application.usePack1) {
            return null;
        }
        return this.sideGroupDao.getSideGroupList(request);
    }

    @GetMapping(value={"/Unit"})
    public ResponseEntity<?> getUnit(HttpServletRequest request) {
        if (!Application.isAccessWebService || !this.application.usePack1) {
            return null;
        }
        return this.unitDao.getUnitList(request);
    }

    @GetMapping(value={"/Product"})
    public ResponseEntity<?> getProduct(HttpServletRequest request) {
        if (!Application.isAccessWebService || !this.application.usePack1) {
            return null;
        }
        return this.productDao.getProductList(request, -1, -1);
    }

    @GetMapping(value={"/Product/{page}/{itemsPerPage}"})
    public ResponseEntity<?> getProduct(HttpServletRequest request, @PathVariable(value="page") int page, @PathVariable(value="itemsPerPage") int itemsPerPage) {
        if (!Application.isAccessWebService || !this.application.usePack1) {
            return null;
        }
        return this.productDao.getProductList(request, itemsPerPage, page);
    }

    @GetMapping(value={"/Product/count"})
    public ResponseEntity<?> getProductCount(HttpServletRequest request) {
        if (!Application.isAccessWebService || !this.application.usePack1) {
            return null;
        }
        return this.productDao.getProductCount(request);
    }

    @PostMapping(value={"/MainGroup"}, consumes={"application/json"})
    public ResponseEntity<?> postMainGroup(@RequestBody String body) {
        if (!Application.isAccessWebService || !this.application.usePack2) {
            return null;
        }
        return this.mainGroupDao.postMainGroupList(body, 0, true);
    }

    @PutMapping(value={"/MainGroup"}, consumes={"application/json"})
    public ResponseEntity<?> putMainGroup(@RequestBody String body) {
        if (!Application.isAccessWebService || !this.application.usePack2) {
            return null;
        }
        return this.mainGroupDao.postMainGroupList(body, 1, true);
    }

    @PostMapping(value={"/MainGroupZ"}, consumes={"application/json"})
    public ResponseEntity<?> postMainGroup(@RequestBody byte[] body) {
        if (!Application.isAccessWebService || !this.application.usePack2) {
            return null;
        }
        return this.mainGroupDao.postMainGroupList(ConvertStr.deCompressionGZip((byte[])body), 0, false);
    }

    @PostMapping(value={"/SideGroup"}, consumes={"application/json"})
    public ResponseEntity<?> postSideGroup(@RequestBody String body) {
        if (!Application.isAccessWebService || !this.application.usePack2) {
            return null;
        }
        return this.sideGroupDao.postSideGroupList(body, 0, true);
    }

    @PutMapping(value={"/SideGroup"}, consumes={"application/json"})
    public ResponseEntity<?> putSideGroup(@RequestBody String body) {
        if (!Application.isAccessWebService || !this.application.usePack2) {
            return null;
        }
        return this.sideGroupDao.postSideGroupList(body, 1, true);
    }

    @PostMapping(value={"/SideGroupZ"}, consumes={"application/json"})
    public ResponseEntity<?> postSideGroup(@RequestBody byte[] body) {
        if (!Application.isAccessWebService || !this.application.usePack2) {
            return null;
        }
        return this.sideGroupDao.postSideGroupList(ConvertStr.deCompressionGZip((byte[])body), 0, false);
    }

    @PostMapping(value={"/Product"}, consumes={"application/json"})
    public ResponseEntity<?> postProduct(@RequestBody String body) {
        if (!Application.isAccessWebService || !this.application.usePack2) {
            return null;
        }
        return this.productDao.postProductList(body, 0, true);
    }

    @PutMapping(value={"/Product"}, consumes={"application/json"})
    public ResponseEntity<?> putProduct(@RequestBody String body) {
        if (!Application.isAccessWebService || !this.application.usePack2) {
            return null;
        }
        return this.productDao.postProductList(body, 1, true);
    }

    @PostMapping(value={"/ProductZ"}, consumes={"application/json"})
    public ResponseEntity<?> postProduct(@RequestBody byte[] body) {
        if (!Application.isAccessWebService || !this.application.usePack2) {
            return null;
        }
        return this.productDao.postProductList(ConvertStr.deCompressionGZip((byte[])body), 0, false);
    }

    @ApiIgnore
    @DeleteMapping(value={"/Product"})
    public ResponseEntity<?> deleteProduct(@RequestParam(value="cms-ids") long[] cmsIds) {
        return this.productDao.deleteProduct(cmsIds);
    }

    @PostMapping(value={"/Product/build"}, consumes={"application/json"})
    public ResponseEntity<?> buildProduct(@RequestBody ProductBuildDto body) {
        if (!Application.isAccessWebService || !this.application.usePack2) {
            return null;
        }
        return this.productDao.buildProduct(body);
    }

    @PostMapping(value={"/Product/transfer"}, consumes={"application/json"})
    public ResponseEntity<?> transferProduct(@RequestBody ProductTransferDto body) {
        if (!Application.isAccessWebService || !this.application.usePack2) {
            return null;
        }
        return this.productDao.transferProduct(body);
    }
}

