/*
 * Decompiled with CFR 0.152.
 */
package com.security;

import com.dto.LoginDto;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.util.Date;
import java.util.HashMap;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="singleton")
public class TokenStore {
    public String createToken(LoginDto login) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("username", login.getUserName());
        claims.put("supervisor", login.getSuperVizor());
        claims.put("databaseName", login.getDatabaseName());
        claims.put("serial", login.getSerial());
        claims.put("userCodeInc", login.getUserCodeInc());
        claims.put("isTnc", login.getIsTorfehNegar() != null && login.getIsTorfehNegar() != false);
        claims.put("isAndroid", login.isAndroid());
        claims.put("isMyHoloo", login.getIsMyHoloo() != null && login.getIsMyHoloo() != false);
        claims.put("isPosLog", login.isPosLog());
        claims.put("subSystemId", login.getSubSystemId());
        claims.put("complimentary", login.isComplimentaryActive());
        JwtBuilder jwtBuilder = Jwts.builder().addClaims(claims).setExpiration(new Date(System.currentTimeMillis() + 86400000L)).signWith(signatureAlgorithm, "SecretKeyToGenJWTs");
        return "Bearer " + jwtBuilder.compact();
    }
}

