/*
 * Decompiled with CFR 0.152.
 */
package com.service.customer;

import com.core.util.filter.Filter;
import com.core.util.filter.GenericParamFactory;
import com.core.util.filter.InternalFilter;
import com.customer.data.CustomerRepo;
import com.dao.SellerDetailDao;
import com.dto.CustomerDto;
import com.dto.LoginDto;
import com.dto.SellerDetailDto;
import com.utility.ConvertStr;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class SellerDetailService {
    private final SellerDetailDao dao;
    private final CustomerRepo customerRepo;

    public ResponseEntity<?> postSellerDetail(List<SellerDetailDto> body) {
        LoginDto login = this.dao.login();
        try {
            for (SellerDetailDto dto : body) {
                dto.setCustomerCode(this.getCustomerCode(dto, login));
                dto.setProductCode(this.getProductCode(dto, login));
                this.checkSellerErrors(dto, login);
                this.dao.insert(dto, login);
            }
        }
        catch (TncException e) {
            return ConvertStr.getMapResponseEntity((String)"Seller", Collections.singletonList(e.getErrorMap()), Collections.emptyList());
        }
        catch (Exception e) {
            TncException ex = new TncException(TncExceptionMessages.DEFAULT_ERROR);
            return ConvertStr.getMapResponseEntity((String)"Seller", Collections.singletonList(ex.makeErrorWithCause((Throwable)e)), Collections.emptyList());
        }
        return ConvertStr.getMapResponseEntity((String)"Seller", Collections.emptyList(), Collections.singletonList(Collections.singletonMap("Success", true)));
    }

    private String getProductCode(SellerDetailDto dto, LoginDto login) {
        if (!login.getIsTorfehNegar().booleanValue()) {
            return ConvertStr.decrypt((String)dto.getProductErpCode());
        }
        dto.setProductErpCode(String.valueOf(dto.getCmsProductId()));
        return this.dao.findProductCodeByCMSId(dto.getCmsProductId(), login);
    }

    private String getCustomerCode(SellerDetailDto dto, LoginDto login) {
        if (!login.getIsTorfehNegar().booleanValue()) {
            return ConvertStr.decrypt((String)dto.getCustomerErpCode());
        }
        List customerList = this.customerRepo.getCustomers((Filter)new InternalFilter(ConvertStr.buildMap(map -> map.put("nationalCode", dto.getCustomerNationalCode())), GenericParamFactory.CUSTOMER));
        if (customerList.isEmpty()) {
            throw new TncException(TncExceptionMessages.INVALID_CUSTOMER_CODE);
        }
        dto.setCustomerErpCode(dto.getCustomerNationalCode());
        return ConvertStr.decrypt((String)((CustomerDto)customerList.get(0)).getErpcode());
    }

    private void checkSellerErrors(@NotNull SellerDetailDto dto, LoginDto login) throws TncException {
        Map sellerState = this.getAndCheckSeller(dto, login);
        if (!((Object)sellerState.getOrDefault("IsSeller", false)).equals(true)) {
            throw new TncException(TncExceptionMessages.CUSTOMER_NOT_PROXY_SELLER);
        }
        this.checkProxyProduct(dto, login);
        SellerDetailDto sellerDtl = this.dao.getSellerDtl(dto.getCustomerCode(), dto.getProductCode(), login);
        if (sellerDtl != null) {
            throw new TncException(TncExceptionMessages.CUSTOMER_ALREADY_SELLS_THIS_PRODUCT.setArgs(new Object[]{dto.getCustomerErpCode(), dto.getProductErpCode()}));
        }
        this.checkCommission(dto);
    }

    private void checkCommission(@NotNull SellerDetailDto dto) {
        if (dto.getCommission() == null || dto.getCommission() <= 0.0 || dto.getCommission() > 100.0) {
            throw new TncException(TncExceptionMessages.COMMISSION_MUST_BE_PERCENTAGE);
        }
    }

    private void checkProxyProduct(@NotNull SellerDetailDto dto, LoginDto login) {
        if (ConvertStr.isNullOrEmpty((String)dto.getProductCode())) {
            throw new TncException(TncExceptionMessages.INVALID_PRODUCT_CODE);
        }
        if (this.dao.productNotExist(dto.getProductCode(), login)) {
            throw new TncException(TncExceptionMessages.INVALID_PRODUCT_CODE);
        }
    }

    @NotNull
    private Map<String, Object> getAndCheckSeller(@NotNull SellerDetailDto dto, LoginDto login) {
        if (ConvertStr.isNullOrEmpty((String)dto.getCustomerCode())) {
            throw new TncException(TncExceptionMessages.INVALID_CUSTOMER_CODE);
        }
        Map sellerState = this.dao.getCustomerSellerState(dto.getCustomerCode(), login);
        if (this.customerNotExist(sellerState)) {
            throw new TncException(TncExceptionMessages.INVALID_CUSTOMER_CODE);
        }
        return sellerState;
    }

    private boolean customerNotExist(Map<String, Object> customer) {
        return customer == null || customer.isEmpty();
    }

    public ResponseEntity<?> putSellerDetail(List<SellerDetailDto> body) {
        LoginDto login = this.dao.login();
        try {
            for (SellerDetailDto dto : body) {
                dto.setCustomerCode(this.getCustomerCode(dto, login));
                dto.setProductCode(this.getProductCode(dto, login));
                this.getAndCheckSeller(dto, login);
                this.checkProxyProduct(dto, login);
                this.checkCommission(dto);
                this.dao.update(dto, login);
            }
        }
        catch (TncException e) {
            return ConvertStr.getMapResponseEntity((String)"Seller", Collections.singletonList(e.getErrorMap()), Collections.emptyList());
        }
        catch (Exception e) {
            TncException ex = new TncException(TncExceptionMessages.DEFAULT_ERROR);
            return ConvertStr.getMapResponseEntity((String)"Seller", Collections.singletonList(ex.makeErrorWithCause((Throwable)e)), Collections.emptyList());
        }
        return ConvertStr.getMapResponseEntity((String)"Seller", Collections.emptyList(), Collections.singletonList(Collections.singletonMap("Success", true)));
    }

    public ResponseEntity<?> getSellerDetails(HttpServletRequest request) {
        return this.dao.getSellerDtlList(request);
    }

    public SellerDetailService(SellerDetailDao dao, CustomerRepo customerRepo) {
        this.dao = dao;
        this.customerRepo = customerRepo;
    }
}

