/*
 * Decompiled with CFR 0.152.
 */
package com.service.invoice;

import com.dao.InvoiceExpenseDao;
import com.dao.SarfaslDao;
import com.dto.InvoiceDto;
import com.dto.InvoiceExpenseDto;
import com.dto.LoginDto;
import com.dto.PaymentDetailDto;
import com.service.invoice.CheckPayError;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.Pair;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.jdbc.support.rowset.SqlRowSet;

public abstract class BaseCostIncome {
    private final DbConnection dbConnection;
    private final InvoiceExpenseDao expenseDao;
    private final SarfaslDao sarfaslDao;

    public BaseCostIncome(DbConnection dbConnection, InvoiceExpenseDao expenseDao, SarfaslDao sarfaslDao) {
        this.dbConnection = dbConnection;
        this.expenseDao = expenseDao;
        this.sarfaslDao = sarfaslDao;
    }

    public List<InvoiceExpenseDto> getModifiedList(InvoiceDto.InvoiceInfo invoiceInfo, LoginDto login, CheckPayError checkPayError) throws TncException {
        LinkedHashMap<String, Integer> customersWithAddedNumLines = new LinkedHashMap<String, Integer>();
        ArrayList<InvoiceExpenseDto> modifiedInfo = new ArrayList<InvoiceExpenseDto>();
        int numLine = 1;
        for (InvoiceExpenseDto dto : this.getList(invoiceInfo)) {
            String customerId = ConvertStr.decrypt((String)dto.getCustomererpcode());
            this.assertCustomerAvailable(customerId, login);
            this.assertCostIsOK(dto, login, checkPayError);
            this.setExpenseObject(dto, invoiceInfo, login);
            if (!customersWithAddedNumLines.containsKey(dto.getCustomererpcode())) {
                customersWithAddedNumLines.put(dto.getCustomererpcode(), numLine);
                dto.setLinenumber(Integer.valueOf(numLine));
                ++numLine;
            } else {
                dto.setLinenumber((Integer)customersWithAddedNumLines.get(dto.getCustomererpcode()));
            }
            this.expenseDao.insert(dto, login);
            modifiedInfo.add(dto);
        }
        return modifiedInfo;
    }

    private void assertCustomerAvailable(String customerId, LoginDto login) throws TncException {
        int countOfCustomer = 0;
        String sqlStr = "SELECT COUNT(*) CNT FROM CUSTOMER WHERE C_CODE = '" + customerId + "'";
        SqlRowSet rs = this.dbConnection.getJdbcTemplate(login).queryForRowSet(login.makeUseDbSql() + sqlStr);
        while (rs.next()) {
            countOfCustomer = rs.getInt("CNT");
        }
        if (countOfCustomer == 0) {
            throw new TncException(TncExceptionMessages.INVALID_CUSTOMER_CODE);
        }
    }

    private void assertCostIsOK(InvoiceExpenseDto dto, LoginDto login, CheckPayError checkPayError) throws TncException {
        CheckPayError.PayErrorType idxErrorPay = checkPayError.checkErrorPay(dto.getAmount().doubleValue(), dto.getSarfaslcode(), this.getType(), login);
        if (idxErrorPay.equals((Object)CheckPayError.PayErrorType.SARFASL_ERROR)) {
            throw new TncException(this.getSarfaslError());
        }
        if (idxErrorPay.equals((Object)CheckPayError.PayErrorType.PRICE_ERROR)) {
            throw new TncException(this.getPriceError());
        }
    }

    private void setExpenseObject(InvoiceExpenseDto expenseObject, InvoiceDto.InvoiceInfo invoice, LoginDto login) {
        String baseSarfaslName = this.sarfaslDao.getNameByCode(expenseObject.getSarfaslcode(), login);
        Pair customer = this.sarfaslDao.getCustomerCodeNamePairByCustomerCode(ConvertStr.decrypt((String)expenseObject.getCustomererpcode()), login);
        String sarfaslCustomerCode = (String)customer.getLeft();
        String sarfaslCustomerName = (String)customer.getRight();
        expenseObject.setFaccode(invoice.getId());
        expenseObject.setFactype(invoice.getType());
        expenseObject.setSanadcode(invoice.getSanadcode());
        expenseObject.setSarfaslnamehaz(baseSarfaslName);
        expenseObject.setSarfaslcodecust(sarfaslCustomerCode);
        expenseObject.setSarfaslnamecust(sarfaslCustomerName);
    }

    public double getSumOfAllPrices(InvoiceDto.InvoiceInfo invoiceInfo) {
        double sumOfAllPrices = 0.0;
        List additionalPrices = this.getList(invoiceInfo);
        for (InvoiceExpenseDto dto : additionalPrices) {
            double price = dto.getAmount() == null ? 0.0 : dto.getAmount();
            sumOfAllPrices += price;
        }
        return sumOfAllPrices;
    }

    public double getSumOfInvoiceCustomerPrices(InvoiceDto.InvoiceInfo invoiceInfo) {
        double sumOfInvoiceCustomerPrices = 0.0;
        List additionalPrices = this.getList(invoiceInfo);
        for (InvoiceExpenseDto dto : additionalPrices) {
            if (!invoiceInfo.getCustomererpcode().equals(dto.getCustomererpcode())) continue;
            double price = dto.getAmount() == null ? 0.0 : dto.getAmount();
            sumOfInvoiceCustomerPrices += price;
        }
        return sumOfInvoiceCustomerPrices;
    }

    PaymentDetailDto.Builder makeSanadHeader(InvoiceExpenseDto dto, String invoiceName, InvoiceDto.InvoiceInfo invoiceInfo) {
        String costSarfasl = dto.getSarfaslcode();
        return PaymentDetailDto.builder().colcode(costSarfasl.substring(0, 3)).moiencode(costSarfasl.substring(3, 7)).tafzilicode(costSarfasl.substring(7)).bed(Double.valueOf(this.getBedHeader(dto))).bes(Double.valueOf(this.getBesHeader(dto))).typeline("N").commentline(invoiceName + " \u0634\u0645\u0627\u0631\u0647" + invoiceInfo.getCode() + "-\u0627\u0632 " + invoiceInfo.getCustomername()).numberline(Double.valueOf(dto.getLinenumber().doubleValue()));
    }

    PaymentDetailDto.Builder makeSanadCustomerDetail(InvoiceExpenseDto dto, String invoiceName, InvoiceDto.InvoiceInfo invoiceInfo) {
        String customerSarfasl = dto.getSarfaslcodecust();
        return PaymentDetailDto.builder().colcode(customerSarfasl.substring(0, 3)).moiencode(customerSarfasl.substring(3, 7)).tafzilicode(customerSarfasl.substring(7)).bed(Double.valueOf(this.getBedDetail(dto))).bes(Double.valueOf(this.getBesDetail(dto))).typeline(" ").commentline(dto.getSarfaslnamecust() + " \u0628\u0627\u0628\u062a \u0641\u0627\u06a9\u062a\u0648\u0631 " + invoiceName + " " + invoiceInfo.getCode()).numberline(Double.valueOf(dto.getLinenumber().doubleValue()));
    }

    protected abstract List<InvoiceExpenseDto> getList(InvoiceDto.InvoiceInfo var1);

    protected abstract CheckPayError.SarfaslType getType();

    protected abstract TncExceptionMessages getSarfaslError();

    protected abstract TncExceptionMessages getPriceError();

    protected abstract double getBedHeader(InvoiceExpenseDto var1);

    protected abstract double getBesHeader(InvoiceExpenseDto var1);

    protected abstract double getBedDetail(InvoiceExpenseDto var1);

    protected abstract double getBesDetail(InvoiceExpenseDto var1);

    public abstract List<PaymentDetailDto.Builder> getSanadDetails(InvoiceDto.InvoiceInfo var1, String var2);
}

