/*
 * Decompiled with CFR 0.152.
 */
package com.service.invoice;

import com.dao.SarfaslDao;
import com.dto.LoginDto;
import com.service.invoice.CheckPayError;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import com.utility.TncLog;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Component;

@Component
public class CheckPayError {
    private final DbConnection dbConnection;
    private final SarfaslDao sarfaslDao;
    private final TncLog log;

    public CheckPayError(DbConnection dbConnection, SarfaslDao sarfaslDao) {
        this.dbConnection = dbConnection;
        this.sarfaslDao = sarfaslDao;
        this.log = new TncLog();
    }

    public void checkAll(PaymentData paymentData, LoginDto login) {
        PayErrorType idxErrorPay = this.checkErrorPay(paymentData.getCash(), paymentData.getCashHeading(), paymentData.isCheckCashHeading() ? SarfaslType.CASH : SarfaslType.NONE, login);
        if (idxErrorPay.equals((Object)PayErrorType.SARFASL_ERROR)) {
            throw new TncException(TncExceptionMessages.INVALID_CASH_HEADING);
        }
        if (idxErrorPay.equals((Object)PayErrorType.PRICE_ERROR)) {
            throw new TncException(TncExceptionMessages.INVALID_CASH_AMOUNT);
        }
        idxErrorPay = this.checkErrorPay(paymentData.getPos(), paymentData.getPosHeading(), SarfaslType.CARD, login);
        if (idxErrorPay.equals((Object)PayErrorType.SARFASL_ERROR)) {
            throw new TncException(TncExceptionMessages.INVALID_CARD_HEADING.setArgs(new Object[]{login.getDatabaseName() + " - " + paymentData.getPosHeading()}));
        }
        if (idxErrorPay.equals((Object)PayErrorType.PRICE_ERROR)) {
            throw new TncException(TncExceptionMessages.INVALID_CARD_AMOUNT);
        }
        idxErrorPay = this.checkErrorPay(paymentData.getCredit(), "", SarfaslType.NONE, login);
        if (idxErrorPay.equals((Object)PayErrorType.PRICE_ERROR)) {
            throw new TncException(TncExceptionMessages.INVALID_CREDIT_AMOUNT);
        }
        idxErrorPay = this.checkErrorPay(paymentData.getDiscount(), paymentData.getDiscountHeading() == null ? "" : paymentData.getDiscountHeading(), paymentData.getDiscountType() == null ? SarfaslType.NONE : paymentData.getDiscountType(), login);
        if (idxErrorPay.equals((Object)PayErrorType.SARFASL_ERROR)) {
            throw new TncException(TncExceptionMessages.INVALID_DISCOUNT_HEADING);
        }
        if (idxErrorPay.equals((Object)PayErrorType.PRICE_ERROR)) {
            throw new TncException(TncExceptionMessages.INVALID_DISCOUNT_AMOUNT);
        }
    }

    public synchronized PayErrorType checkErrorPay(double price, String sarfasl, SarfaslType type, LoginDto login) {
        if (price == 0.0) {
            return PayErrorType.NO_ERROR;
        }
        if (this.sarfaslHasError(sarfasl, type)) {
            this.log.info(login.getDatabaseName() + " checkPay 1 - price:" + price + " sarfasl:" + sarfasl + " type:" + type);
            return PayErrorType.SARFASL_ERROR;
        }
        if (price < 0.0) {
            return PayErrorType.PRICE_ERROR;
        }
        if (type.equals((Object)SarfaslType.NONE)) {
            return PayErrorType.NO_ERROR;
        }
        if (type.equals((Object)SarfaslType.COST)) {
            if (this.sarfaslDao.getCostSarfaslCountBySarfaslCode(sarfasl, 601, login) == 0) {
                this.log.info(login.getDatabaseName() + " checkPay 2 - price:" + price + " sarfasl:" + sarfasl + " type:" + type);
                return PayErrorType.SARFASL_ERROR;
            }
        } else if (type.equals((Object)SarfaslType.INCOME)) {
            if (this.sarfaslDao.getCostSarfaslCountBySarfaslCode(sarfasl, 702, login) == 0) {
                this.log.info(login.getDatabaseName() + " checkPay 3 - price:" + price + " sarfasl:" + sarfasl + " type:" + type);
                return PayErrorType.SARFASL_ERROR;
            }
        } else {
            if (this.sarfaslDao.getSarfaslCountBySarfaslCodeAndType(sarfasl, type.getType(), login) == 0) {
                this.log.info(login.getDatabaseName() + " checkPay 4 - price:" + price + " sarfasl:" + sarfasl + " type:" + type);
                return PayErrorType.SARFASL_ERROR;
            }
            if (type.equals((Object)SarfaslType.CARD) && !login.getIsMyHoloo().booleanValue()) {
                SqlRowSet rs = this.dbConnection.getJdbcTemplate(login).queryForRowSet(" SELECT Pos FROM ACOUND_N WHERE COL_CODE + MOIEN_CODE + TAFZILI_CODE= '" + sarfasl + "'");
                if (!rs.next()) {
                    return PayErrorType.SARFASL_ERROR;
                }
                do {
                    if (rs.getBoolean("Pos")) continue;
                    this.log.info(login.getDatabaseName() + " checkPay 5 - price:" + price + " sarfasl:" + sarfasl + " type:" + type);
                    return PayErrorType.SARFASL_ERROR;
                } while (rs.next());
            } else if (type.equals((Object)SarfaslType.CASH) && sarfasl.length() != 11) {
                return PayErrorType.SARFASL_ERROR;
            }
        }
        return PayErrorType.NO_ERROR;
    }

    private boolean sarfaslHasError(String sarfasl, SarfaslType type) {
        return !type.equals((Object)SarfaslType.NONE) && ConvertStr.isNullOrEmpty((String)sarfasl);
    }
}

