/*
 * Decompiled with CFR 0.152.
 */
package com.service.invoice;

import com.dao.InvoiceExpenseDao;
import com.dao.SarfaslDao;
import com.dto.InvoiceDto;
import com.dto.InvoiceExpenseDto;
import com.dto.PaymentDetailDto;
import com.service.invoice.BaseCostIncome;
import com.service.invoice.CheckPayError;
import com.utility.DbConnection;
import com.utility.TncExceptionMessages;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExpenseCalculator
extends BaseCostIncome {
    @Autowired
    public ExpenseCalculator(DbConnection dbConnection, InvoiceExpenseDao expenseDao, SarfaslDao sarfaslDao) {
        super(dbConnection, expenseDao, sarfaslDao);
    }

    public List<PaymentDetailDto.Builder> getSanadDetails(InvoiceDto.InvoiceInfo invoiceInfo, String invoiceName) {
        ArrayList<PaymentDetailDto.Builder> sanadList = new ArrayList<PaymentDetailDto.Builder>();
        List expenses = this.getList(invoiceInfo);
        if (expenses == null) {
            return sanadList;
        }
        for (InvoiceExpenseDto dto : expenses) {
            sanadList.add(this.makeSanadHeader(dto, invoiceName, invoiceInfo));
            sanadList.add(this.makeSanadCustomerDetail(dto, invoiceName, invoiceInfo));
        }
        return sanadList;
    }

    protected List<InvoiceExpenseDto> getList(InvoiceDto.InvoiceInfo invoiceInfo) {
        return invoiceInfo.getHazineinfo();
    }

    protected CheckPayError.SarfaslType getType() {
        return CheckPayError.SarfaslType.COST;
    }

    protected TncExceptionMessages getSarfaslError() {
        return TncExceptionMessages.INVALID_COST_HEADING;
    }

    protected TncExceptionMessages getPriceError() {
        return TncExceptionMessages.INVALID_COST_PRICE;
    }

    protected double getBedHeader(InvoiceExpenseDto dto) {
        return dto.getAmount();
    }

    protected double getBesHeader(InvoiceExpenseDto dto) {
        return 0.0;
    }

    protected double getBedDetail(InvoiceExpenseDto dto) {
        return 0.0;
    }

    protected double getBesDetail(InvoiceExpenseDto dto) {
        return dto.getAmount();
    }
}

