/*
 * Decompiled with CFR 0.152.
 */
package com.service.invoice;

import com.dao.InvoiceExpenseDao;
import com.dao.SarfaslDao;
import com.dto.InvoiceDto;
import com.dto.InvoiceExpenseDto;
import com.dto.PaymentDetailDto;
import com.service.invoice.BaseCostIncome;
import com.service.invoice.CheckPayError;
import com.utility.DbConnection;
import com.utility.TncExceptionMessages;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IncomeCalculator
extends BaseCostIncome {
    @Autowired
    public IncomeCalculator(DbConnection dbConnection, InvoiceExpenseDao expenseDao, SarfaslDao sarfaslDao) {
        super(dbConnection, expenseDao, sarfaslDao);
    }

    public List<PaymentDetailDto.Builder> getSanadDetails(InvoiceDto.InvoiceInfo invoiceInfo, String invoiceName) {
        ArrayList<PaymentDetailDto.Builder> sanadList = new ArrayList<PaymentDetailDto.Builder>();
        List incomes = this.getList(invoiceInfo);
        if (incomes == null) {
            return sanadList;
        }
        for (InvoiceExpenseDto dto : incomes) {
            sanadList.add(this.makeSanadCustomerDetail(dto, invoiceName, invoiceInfo));
            sanadList.add(this.makeSanadHeader(dto, invoiceName, invoiceInfo));
        }
        return sanadList;
    }

    protected List<InvoiceExpenseDto> getList(InvoiceDto.InvoiceInfo invoiceInfo) {
        return invoiceInfo.getIncomeinfo();
    }

    protected CheckPayError.SarfaslType getType() {
        return CheckPayError.SarfaslType.INCOME;
    }

    protected TncExceptionMessages getSarfaslError() {
        return TncExceptionMessages.INVALID_INCOME_HEADING;
    }

    protected TncExceptionMessages getPriceError() {
        return TncExceptionMessages.INVALID_INCOME_PRICE;
    }

    protected double getBedHeader(InvoiceExpenseDto dto) {
        return 0.0;
    }

    protected double getBesHeader(InvoiceExpenseDto dto) {
        return dto.getAmount();
    }

    protected double getBedDetail(InvoiceExpenseDto dto) {
        return dto.getAmount();
    }

    protected double getBesDetail(InvoiceExpenseDto dto) {
        return 0.0;
    }
}

