/*
 * Decompiled with CFR 0.152.
 */
package com.service.invoice;

import com.dto.InvoiceDetailDto;
import com.dto.LoginDto;
import com.utility.ConvertStr;
import com.utility.DbLogin;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import com.utility.TncJdbc;
import org.springframework.jdbc.support.rowset.SqlRowSet;

public class ProxyInvoiceService {
    private final TncJdbc jdbcTemplate;
    private double commission = 0.0;

    public ProxyInvoiceService(DbLogin dbLogin) {
        LoginDto loginDto = dbLogin.getLogin();
        this.jdbcTemplate = dbLogin.getDbConnection().getJdbcTemplate(loginDto);
    }

    public double getCommission(InvoiceDetailDto dtl) throws TncException {
        this.checkErrors(dtl);
        return this.commission;
    }

    private void checkErrors(InvoiceDetailDto dtl) throws TncException {
        if (ConvertStr.isNullOrEmpty((String)dtl.getSellererpcode())) {
            throw new TncException(TncExceptionMessages.MUST_HAVE_SELLER_CODE);
        }
        this.checkCustomerIsSeller(dtl);
        this.checkProductHasGivenCustomer(dtl);
    }

    private void checkCustomerIsSeller(InvoiceDetailDto dtl) throws TncException {
        String sellerCode = dtl.getSellererpcode();
        SqlRowSet rs = this.jdbcTemplate.queryForRowSet(" SELECT ISNULL(ISSELLER, 0) isSeller FROM CUSTOMER WHERE C_CODE = ?", new Object[]{sellerCode});
        boolean isNotSeller = true;
        if (rs.next()) {
            boolean bl = isNotSeller = !rs.getBoolean("isSeller");
        }
        if (isNotSeller) {
            throw new TncException(TncExceptionMessages.CUSTOMER_NOT_PROXY_SELLER);
        }
    }

    private void checkProductHasGivenCustomer(InvoiceDetailDto dtl) throws TncException {
        SqlRowSet rowSet = this.jdbcTemplate.queryForRowSet(" SELECT C_CODE, ISNULL(COMMISSION, 0) COMMISSION FROM SellerDetail WHERE A_CODE = ? AND C_CODE = ?", new Object[]{dtl.getProductid(), dtl.getSellererpcode()});
        double tmpCommission = -1.0;
        if (rowSet.next()) {
            tmpCommission = rowSet.getDouble("COMMISSION");
        }
        if (tmpCommission == -1.0) {
            throw new TncException(TncExceptionMessages.CUSTOMER_NOT_EQUALS_PRODUCT_SELLER.setArgs(new Object[]{dtl.getProductid()}));
        }
        if (tmpCommission <= 0.0) {
            throw new TncException(TncExceptionMessages.COMMISSION_MUST_BE_PERCENTAGE);
        }
        this.commission = tmpCommission;
    }

    public String getSellerSarfasl(String customerCode) {
        String sqlStr = " SELECT SARFASL_CODE FROM SARFASL WHERE COMMON ='" + customerCode + "' AND [TYPE] IN (5,15) AND SPARENT = 0 ";
        SqlRowSet rs = this.jdbcTemplate.queryForRowSet(sqlStr);
        if (rs.next()) {
            return rs.getString("SARFASL_CODE");
        }
        return null;
    }

    public void setSellerDataIntoDtl(InvoiceDetailDto dtl) {
        String cCode = this.jdbcTemplate.getLogin().getIsTorfehNegar() != false ? "NATIONAL_CODE = '" + dtl.getSellernationalcode() + "'" : "C_CODE = '" + ConvertStr.decrypt((String)dtl.getSellererpcode()) + "'";
        SqlRowSet rs = this.jdbcTemplate.queryForRowSet(" SELECT ISNULL(sellerWithTax, 1) kindVAT, C_NAME,  C_CODE \n FROM CUSTOMER WHERE " + cCode);
        if (!rs.next()) {
            throw new TncException(TncExceptionMessages.INVALID_CUSTOMER_CODE);
        }
        dtl.setSellererpcode(rs.getString("C_CODE"));
        dtl.setSellerKindVAT(rs.getBoolean("kindVAT") ? 1 : 0);
        dtl.setSellerName(rs.getString("C_NAME"));
        dtl.setSellercommission(this.getCommission(dtl));
        dtl.setSellersarfasl(this.getSellerSarfasl(dtl.getSellererpcode()));
    }
}

