/*
 * Decompiled with CFR 0.152.
 */
package com.service.invoice.commission;

import com.dao.HolooSettingsDao;
import com.dto.InvoiceDetailDto;
import com.dto.InvoiceDto;
import com.dto.LoginDto;
import com.dto.PaymentDetailDto;
import com.service.invoice.commission.BaseMidMenCommission;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.DbLogin;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import com.utility.TncJdbc;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.lang.NonNull;

abstract class BaseMidMenCommission {
    protected final HolooSettingsDao settingsDao;
    protected final TncJdbc jdbc;
    protected final LoginDto login;
    protected final InvoiceDto.InvoiceInfo invoice;
    protected double totalCommPrice = 0.0;
    private boolean addCommissionToMidManAccount;
    private boolean calcCommissionAfterDiscount;

    public BaseMidMenCommission(DbLogin dbLogin, InvoiceDto.InvoiceInfo invoice) {
        DbConnection dbConnection = dbLogin.getDbConnection();
        this.login = dbLogin.getLogin();
        this.settingsDao = new HolooSettingsDao(dbConnection);
        this.jdbc = dbConnection.getJdbcTemplate(this.login);
        this.invoice = invoice;
        this.fetchSettings();
    }

    private void fetchSettings() {
        Map result = this.settingsDao.getMapMultiple(rowSet -> rowSet.getBoolean("Boolean"), "[Boolean]", "0", this.login, new String[]{"SaveCustForVaseteh", "PorsantAfterTakhfif"});
        this.addCommissionToMidManAccount = result.getOrDefault("SaveCustForVaseteh", false);
        this.calcCommissionAfterDiscount = result.getOrDefault("PorsantAfterTakhfif", false);
    }

    public final void calculateCommission() throws TncException {
        if (this.invoice.getCommission() == null && ConvertStr.isNullOrEmpty((String)this.invoice.getMidmanerpcode()) && this.noDtlHasMidManCode()) {
            return;
        }
        this.throwIfError();
        if (this.invoice.getCommission() != null && this.isTotalCommissionAvailable()) {
            this.totalCommPrice = this.invoice.getCommission();
            return;
        }
        this.totalCommPrice = this.innerCalculateCommission();
    }

    @NonNull
    public final List<PaymentDetailDto> getCommissionSndListData() {
        if (!this.addCommissionToMidManAccount || this.totalCommPrice == 0.0) {
            return new ArrayList<PaymentDetailDto>();
        }
        return this.internalCommissionSndListData();
    }

    public final void insertFConnect() {
        if (this.totalCommPrice == 0.0) {
            return;
        }
        this.jdbc.update(this.getFConnectInsertSql() + this.generateInsertFConnectValues());
    }

    public void updateFactArt() {
        if (this.totalCommPrice == 0.0) {
            return;
        }
        for (InvoiceDetailDto dtl : this.invoice.getDetailinfo()) {
            this.jdbc.update("UPDATE FactArt SET DarsadPorsant = ?, VASETEH_CODE = ? WHERE A_CODE = ? AND  FAC_CODE = ? AND FAC_TYPE = ? AND A_INDEX = ?", new Object[]{ConvertStr.nullSafeDouble((Double)dtl.getMidmancommissionpercent()), this.getMidManCodeForFactArt(dtl), dtl.getProductid(), this.invoice.getId(), this.invoice.getType(), dtl.getAindex()});
        }
    }

    private boolean noDtlHasMidManCode() {
        AtomicBoolean b = new AtomicBoolean(true);
        for (InvoiceDetailDto dtl : this.invoice.getDetailinfo()) {
            b.set(b.get() && ConvertStr.isNullOrEmpty((String)dtl.getMidmanerpcode()));
            if (b.get()) continue;
            break;
        }
        return b.get();
    }

    private void throwIfError() {
        if (this.invoice.getCommission() != null && ConvertStr.isNullOrEmpty((String)this.invoice.getMidmanerpcode())) {
            throw new TncException(TncExceptionMessages.INVALID_MEDIATOR_ERP_CODE);
        }
    }

    private String getFConnectInsertSql() {
        return "INSERT INTO FCounect(FAC_CODE, FAC_TYPE, SANAD_CODE, C_CODE, CalcType, SARFASL_CODE, TakhfifType, \n COUNECT_CODE, DARSAD_PORSUNT, CUST_PORSUNT, \n A_Code, Priority, Agent) \nVALUES ";
    }

    protected boolean isTotalCommissionAvailable() {
        return true;
    }

    protected String generateInsertFConnectValues() {
        return "(" + this.getFConnectCommonValues() + "'" + this.invoice.getMidmanerpcode() + "', " + this.getMidManCommissionPercent(this.invoice.getMidmanerpcode()) + ", " + this.totalCommPrice + ", NULL, 1, 0)";
    }

    protected final String getFConnectCommonValues() {
        return "'" + this.invoice.getId() + "', '" + this.invoice.getType() + "', " + this.invoice.getSanadcode() + ",'" + this.invoice.getCustomerid() + "', -1, '" + this.getCostHeadingForFConnect() + "', 1, ";
    }

    protected double getMidManCommissionPercent(String midManCode) {
        SqlRowSet rs = this.jdbc.queryForRowSet("select VASETEH_PORSANT FROM CustomerVaseteh  WHERE C_CODE = ? AND VASETEH_CODE = ?", new Object[]{this.invoice.getCustomerid(), midManCode});
        if (rs.next()) {
            return rs.getDouble("VASETEH_PORSANT");
        }
        return this.getMidManCommissionFromCustomerTable(midManCode);
    }

    protected final double getMidManCommissionFromCustomerTable(String midManCode) {
        SqlRowSet rs = this.jdbc.queryForRowSet("SELECT IsNull(VASETEH_PORSANT, 0) MidManComm \n FROM CUSTOMER WHERE C_CODE = ?", new Object[]{midManCode});
        if (rs.next()) {
            return rs.getDouble("MidManComm");
        }
        return 0.0;
    }

    protected final String getMidManHeading(String midManId) {
        SqlRowSet rs = this.jdbc.queryForRowSet("SELECT SARFASL_CODE FROM SARFASL WHERE ([TYPE] = 5 OR [TYPE] = 15) \n AND [COMMON] = ?", new Object[]{midManId});
        if (rs.next()) {
            return rs.getString("SARFASL_CODE");
        }
        return "";
    }

    protected final boolean isCalcCommissionAfterDiscount() {
        return this.calcCommissionAfterDiscount;
    }

    protected final String getCostHeading() {
        String heading = this.settingsDao.getMSetup2String(this.login, "HazVaseteh", "");
        if (!heading.isEmpty()) {
            return heading;
        }
        SqlRowSet rs = this.jdbc.queryForRowSet("SELECT top 1 SARFASL_CODE FROM SARFASL WHERE [TYPE] = 28");
        if (rs.next()) {
            return rs.getString("SARFASL_CODE");
        }
        return "";
    }

    protected String getCostHeadingForFConnect() {
        return this.getCostHeading();
    }

    protected final String getMidManName(String midManId) {
        SqlRowSet rs = this.jdbc.queryForRowSet("SELECT C_NAME FROM CUSTOMER WHERE C_CODE = ?", new Object[]{midManId});
        if (rs.next()) {
            return rs.getString("C_NAME");
        }
        return "";
    }

    protected abstract double innerCalculateCommission();

    @NonNull
    protected List<PaymentDetailDto> internalCommissionSndListData() {
        ArrayList<PaymentDetailDto> result = new ArrayList<PaymentDetailDto>();
        PaymentDetailDto midManCommRow = this.getCommRow(this.getMidManHeading(this.invoice.getMidmanerpcode()), this.totalCommPrice);
        PaymentDetailDto commCostRow = this.getCommCostSndListRow();
        result.add(midManCommRow);
        result.add(commCostRow);
        return result;
    }

    protected final PaymentDetailDto getCommRow(@NotNull String midManHeading, double rowPrice) {
        String midManCol = midManHeading.substring(0, 3);
        String midManMoien = midManHeading.substring(3, 7);
        String midManTafsili = midManHeading.substring(7);
        PaymentDetailDto.Builder midManCommRow = PaymentDetailDto.builder().colcode(midManCol).moiencode(midManMoien).tafzilicode(midManTafsili);
        switch (1.$SwitchMap$com$dao$InvoiceDao$InvoiceType[this.invoice.getInvoiceType().ordinal()]) {
            case 1: {
                midManCommRow.bes(Double.valueOf(rowPrice)).commentline("\u06a9\u0645\u06cc\u0633\u06cc\u0648\u0646 \u0641\u0631\u0648\u0634 " + this.invoice.getCode() + " - " + this.invoice.getCustomername());
                break;
            }
            case 2: {
                midManCommRow.bed(Double.valueOf(rowPrice)).commentline("\u0628\u0631\u06af\u0634\u062a \u0627\u0632 \u0641\u0631\u0648\u0634 " + this.invoice.getCode() + " - " + this.invoice.getCustomername());
                break;
            }
            case 3: {
                midManCommRow.bes(Double.valueOf(rowPrice)).commentline("\u06a9\u0645\u06cc\u0633\u06cc\u0648\u0646 \u062e\u0631\u06cc\u062f " + this.invoice.getCode() + " - " + this.invoice.getCustomername());
                break;
            }
            case 4: {
                midManCommRow.bed(Double.valueOf(rowPrice)).commentline("\u0628\u0631\u06af\u0634\u062a \u0627\u0632 \u062e\u0631\u06cc\u062f " + this.invoice.getCode() + " - " + this.invoice.getCustomername());
            }
        }
        return midManCommRow.build();
    }

    protected final PaymentDetailDto getCommCostSndListRow() {
        String commHeading = this.getCostHeading();
        String commCol = commHeading.substring(0, 3);
        String commMoien = commHeading.substring(3, 7);
        PaymentDetailDto.Builder commCostRow = PaymentDetailDto.builder().bed(Double.valueOf(this.totalCommPrice)).colcode(commCol).moiencode(commMoien).commentline(this.getMidManName(this.invoice.getMidmanerpcode()) + " - \u0641\u0627\u06a9\u062a\u0648\u0631 " + this.invoice.getCode());
        switch (1.$SwitchMap$com$dao$InvoiceDao$InvoiceType[this.invoice.getInvoiceType().ordinal()]) {
            case 2: 
            case 4: {
                commCostRow.bed(Double.valueOf(0.0)).bes(Double.valueOf(this.totalCommPrice));
            }
        }
        return commCostRow.build();
    }

    protected final void emptyUserGivenDtlMidManCodes() {
        for (InvoiceDetailDto dtl : this.invoice.getDetailinfo()) {
            if (ConvertStr.isNullOrEmpty((String)dtl.getMidmanerpcode())) continue;
            dtl.setMidmanerpcode(null);
        }
    }

    protected String getMidManCodeForFactArt(InvoiceDetailDto dtl) {
        return dtl.getMidManCode();
    }
}

