/*
 * Decompiled with CFR 0.152.
 */
package com.service.invoice.commission;

import com.dto.InvoiceDetailDto;
import com.dto.InvoiceDto;
import com.google.common.util.concurrent.AtomicDouble;
import com.service.invoice.commission.BaseMidMenCommission;
import com.service.invoice.commission.ProductMidMenCommission;
import com.service.invoice.commission.util.CodeFinder;
import com.utility.ConvertStr;
import com.utility.DbLogin;
import java.util.List;
import org.springframework.jdbc.support.rowset.SqlRowSet;

class MGroupMidMenCommission
extends BaseMidMenCommission {
    private final ProductMidMenCommission productCommission;
    private boolean mGroupCommPerMidMan;

    public MGroupMidMenCommission(DbLogin dbLogin, InvoiceDto.InvoiceInfo invoice) {
        super(dbLogin, invoice);
        this.productCommission = new ProductMidMenCommission(dbLogin, invoice);
        this.fetchSettings();
    }

    private void fetchSettings() {
        this.mGroupCommPerMidMan = this.settingsDao.getMSetup2Boolean(this.login, "MGroupForVaseteh");
    }

    protected double innerCalculateCommission() {
        this.emptyUserGivenDtlMidManCodes();
        if (!this.mGroupCommPerMidMan) {
            return this.calcNormal();
        }
        this.productCommission.checkErrorsForMidManPerDtlOption(dtl -> dtl.fetchMainGroupId() + "-" + dtl.getMidManCode());
        return this.productCommission.calcPerMidMan(dtl -> this.getId(dtl) + "-" + dtl.getMidManCode());
    }

    private double calcNormal() {
        CodeFinder codeFinder = new CodeFinder(new CodeFinder.CodeFinderArgs(InvoiceDetailDto::fetchMainGroupId, arg_0 -> ((ProductMidMenCommission)this.productCommission).calculateMidManDefaultComm(arg_0), arg_0 -> ((ProductMidMenCommission)this.productCommission).getFinalSumPrice(arg_0), this.invoice.getDetailinfo()));
        AtomicDouble sumOfCommissionPrices = codeFinder.getProvidedCommSum();
        SqlRowSet rs = this.jdbc.queryForRowSet("SELECT M_GroupCode mCode, \n IsNull(DarsadPorsant, 0) comm \n FROM M_GROUP WHERE M_GroupCode IN (" + ConvertStr.commaBindStringsWithQuotes(codeFinder.getNoCommProvidedCodes().keySet()) + ")");
        sumOfCommissionPrices.addAndGet(this.productCommission.readCommissionFromRowSet(rs, codeFinder, "mCode"));
        while (rs.next()) {
            List dataList = (List)codeFinder.getNoCommProvidedCodes().get(rs.getString("mCode"));
            for (InvoiceDetailDto data : dataList) {
                sumOfCommissionPrices.addAndGet(this.productCommission.calculateFinalSum(rs.getDouble("comm"), data));
            }
        }
        return sumOfCommissionPrices.get();
    }

    private String getId(InvoiceDetailDto dtl) {
        return dtl.fetchMainGroupId();
    }

    protected String getMidManCodeForFactArt(InvoiceDetailDto dtl) {
        return "";
    }
}

