/*
 * Decompiled with CFR 0.152.
 */
package com.service.invoice.commission;

import com.dto.InvoiceDetailDto;
import com.dto.InvoiceDto;
import com.google.common.util.concurrent.AtomicDouble;
import com.service.invoice.commission.BaseMidMenCommission;
import com.service.invoice.commission.ProductMidMenCommission;
import com.service.invoice.commission.util.CodeFinder;
import com.utility.ConvertStr;
import com.utility.DbLogin;
import org.springframework.jdbc.support.rowset.SqlRowSet;

class SGroupMidMenCommission
extends BaseMidMenCommission {
    private final ProductMidMenCommission productCommission;
    private boolean sGroupCommPerMidMan;

    public SGroupMidMenCommission(DbLogin dbLogin, InvoiceDto.InvoiceInfo invoice) {
        super(dbLogin, invoice);
        this.productCommission = new ProductMidMenCommission(dbLogin, invoice);
        this.fetchSettings();
    }

    protected void fetchSettings() {
        this.sGroupCommPerMidMan = this.settingsDao.getMSetup2Boolean(this.login, "SGroupForVaseteh");
    }

    protected double innerCalculateCommission() {
        this.emptyUserGivenDtlMidManCodes();
        if (!this.sGroupCommPerMidMan) {
            return this.calcNormal();
        }
        this.productCommission.checkErrorsForMidManPerDtlOption(dtl -> dtl.fetchSubGroupFullId() + "-" + dtl.getMidManCode());
        return this.productCommission.calcPerMidMan(dtl -> dtl.fetchSubGroupFullId() + "-" + dtl.getMidManCode());
    }

    private double calcNormal() {
        CodeFinder codeFinder = new CodeFinder(new CodeFinder.CodeFinderArgs(arg_0 -> this.getId(arg_0), arg_0 -> ((ProductMidMenCommission)this.productCommission).calculateMidManDefaultComm(arg_0), arg_0 -> ((ProductMidMenCommission)this.productCommission).getFinalSumPrice(arg_0), this.invoice.getDetailinfo()));
        AtomicDouble sumOfCommissionPrices = codeFinder.getProvidedCommSum();
        SqlRowSet rs = this.jdbc.queryForRowSet("SELECT M_GroupCode + S_GroupCode sCode, \n IsNull(DarsadPorsant, 0) comm \n FROM S_GROUP WHERE M_GroupCode + S_GroupCode IN (" + ConvertStr.commaBindStringsWithQuotes(codeFinder.getNoCommProvidedCodes().keySet()) + ")");
        sumOfCommissionPrices.addAndGet(this.productCommission.readCommissionFromRowSet(rs, codeFinder, "sCode"));
        return sumOfCommissionPrices.get();
    }

    private String getId(InvoiceDetailDto dtl) {
        return dtl.fetchSubGroupFullId();
    }

    protected String getMidManCodeForFactArt(InvoiceDetailDto dtl) {
        return "";
    }
}

