/*
 * Decompiled with CFR 0.152.
 */
package com.service.invoice.commission.util;

import com.dto.InvoiceDetailDto;
import com.google.common.util.concurrent.AtomicDouble;
import com.service.invoice.commission.util.CodeFinder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CodeFinder {
    private final Map<String, List<InvoiceDetailDto>> noCommProvidedCodes = new ConcurrentHashMap();
    private AtomicDouble providedCommSum = new AtomicDouble(0.0);

    public CodeFinder(CodeFinderArgs codeFinderArgs) {
        for (InvoiceDetailDto dtl : codeFinderArgs.getDtlList()) {
            if (dtl.getMidmancommissionpercent() == null) {
                this.addToNoCommCodes(codeFinderArgs, dtl);
                continue;
            }
            this.providedCommSum.addAndGet((Double)codeFinderArgs.getCalcDtlSumPrice().apply(dtl) * dtl.getMidmancommissionpercent() / 100.0);
            this.providedCommSum.addAndGet(((Double)codeFinderArgs.getCalculateMidManDefaultComm().apply(dtl)).doubleValue());
        }
    }

    private void addToNoCommCodes(CodeFinderArgs codeFinderArgs, InvoiceDetailDto dtl) {
        String code = (String)codeFinderArgs.getKeyMaker().apply(dtl);
        ArrayList<InvoiceDetailDto> sameKeyDtls = (ArrayList<InvoiceDetailDto>)this.noCommProvidedCodes.remove(code);
        if (sameKeyDtls == null) {
            sameKeyDtls = new ArrayList<InvoiceDetailDto>();
        }
        sameKeyDtls.add(dtl);
        this.noCommProvidedCodes.put(code, sameKeyDtls);
    }

    public Map<String, List<InvoiceDetailDto>> getNoCommProvidedCodes() {
        return this.noCommProvidedCodes;
    }

    public AtomicDouble getProvidedCommSum() {
        return this.providedCommSum;
    }
}

