/*
 * Decompiled with CFR 0.152.
 */
package com.utility;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.ULocale;
import com.utility.TextNormalizer;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateUtils {
    public static final SimpleDateFormat defaultDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
    public static final SimpleDateFormat defaultDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
    public static final SimpleDateFormat defaultTimeFormat = new SimpleDateFormat("HH:mm:ss", Locale.ENGLISH);

    public static String getNowTimeStr() {
        return LocalTime.now().format(DateUtils.getTimeFormatter());
    }

    public static String getNowDateTimeStr() {
        return LocalDateTime.now().format(DateUtils.getDateTimeFormatter());
    }

    public static String getTodayStart() {
        return LocalDate.now().atTime(LocalTime.MIN).format(DateUtils.getDateTimeFormatter());
    }

    @NotNull
    private static DateTimeFormatter getDateTimeFormatter() {
        return DateTimeFormatter.ofPattern(defaultDateTimeFormat.toPattern());
    }

    @NotNull
    private static DateTimeFormatter getTimeFormatter() {
        return DateTimeFormatter.ofPattern(defaultTimeFormat.toPattern());
    }

    public static String getEndTimeStr() {
        return LocalTime.MAX.format(DateUtils.getTimeFormatter());
    }

    public static String timestampToCommonDateTimeStr(Timestamp timestamp) {
        DateTimeFormatter formatter = DateUtils.getDateTimeFormatter();
        return timestamp.toInstant().atZone(ZoneId.systemDefault()).format(formatter);
    }

    public static String normalizeDbDateTime(@NonNull String dbDate) throws DateTimeException {
        return LocalDate.parse(DateUtils.toUniformDateStyle((String)dbDate), DateTimeFormatter.ofPattern("yyyy-MM-dd")).atTime(LocalTime.MIN).format(DateUtils.getDateTimeFormatter());
    }

    public static String normalizeDateTime(Timestamp timestamp) {
        if (timestamp == null) {
            return "";
        }
        return timestamp.toLocalDateTime().format(DateTimeFormatter.ofPattern(defaultDateTimeFormat.toPattern()));
    }

    public static String toUniformDateStyle(String date) {
        return date.replace("/", "-");
    }

    @Nullable
    public static Date parseDate(String dateStr) {
        return DateUtils.parseDate((String)dateStr, (String)defaultDateTimeFormat.toPattern());
    }

    @Nullable
    public static Date parseDate(String dateStr, String pattern) {
        try {
            return org.apache.commons.lang3.time.DateUtils.parseDate((String)DateUtils.toUniformDateStyle((String)dateStr), (String[])new String[]{pattern});
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static LocalDateTime parseLocalDateTime(String dateStr) {
        return LocalDateTime.parse(dateStr, DateUtils.getDateTimeFormatter());
    }

    public static String convertToPersianDate(String dateStr) {
        ULocale persianLocale = new ULocale("fa_IR@calendar=persian");
        Calendar persianCal = Calendar.getInstance((ULocale)persianLocale);
        Date date = DateUtils.parseDate((String)dateStr, (String)defaultDateFormat.toPattern());
        if (date == null) {
            return dateStr;
        }
        persianCal.setTime(date);
        com.ibm.icu.text.SimpleDateFormat persianFormatter = new com.ibm.icu.text.SimpleDateFormat("yyyy/MM/dd", persianLocale);
        String persianDate = persianFormatter.format((Object)persianCal);
        return TextNormalizer.getEnglishText((String)persianDate);
    }
}

