/*
 * Decompiled with CFR 0.152.
 */
package com.utility;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.gson.Gson;
import com.utility.ConvertStr;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonDeserializer<T> {
    Class<T> aClass;

    public JsonDeserializer(Class<T> aClass) {
        this.aClass = aClass;
    }

    public T makeDtoArray(String body, String objectName) throws JSONException {
        JSONObject obj = new JSONObject(body);
        obj = ConvertStr.rebuildJsonObject((JSONObject)obj);
        JSONArray jsonArray = obj.getJSONArray(objectName);
        body = jsonArray.toString();
        return (T)new Gson().fromJson(body, this.aClass);
    }

    public static <O> String toJson(O obj) {
        ObjectWriter writer = new ObjectMapper().writer().withDefaultPrettyPrinter();
        return writer.writeValueAsString(obj);
    }
}

