/*
 * Decompiled with CFR 0.152.
 */
package com.utility;

import com.utility.ConvertStr;
import com.utility.LockCode;
import com.utility.TncJdbc;
import org.jetbrains.annotations.NotNull;
import org.springframework.jdbc.support.rowset.SqlRowSet;

public class LockReader {
    private final TncJdbc jdbcTemplate;
    private final String key;
    private final String lockInfo;

    public LockReader(TncJdbc jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        this.key = this.queryKey();
        this.lockInfo = this.getLockInfo();
    }

    @NotNull
    private String queryKey() {
        StringBuilder key = new StringBuilder();
        String sql = "set nocount on  Select [Integer] From MSETUP2 as db1 where db1.name='F_EncCount'  Union  Select [Integer] From MSETUP2 as db2 where db2.name='L_EncCount' ";
        SqlRowSet rowSet = this.jdbcTemplate.queryForRowSet(sql);
        while (rowSet.next()) {
            key.append(rowSet.getString("Integer"));
        }
        return key.toString();
    }

    @NotNull
    private String getLockInfo() {
        if (this.key.isEmpty()) {
            return "";
        }
        String lockInfo = "";
        String sql = "SELECT * FROM msetup3 WHERE Name ='LckInfo'";
        SqlRowSet rowSet = this.jdbcTemplate.queryForRowSet(sql);
        while (rowSet.next()) {
            lockInfo = rowSet.getString("String");
        }
        if (ConvertStr.isNullOrEmpty((String)lockInfo)) {
            return "";
        }
        return ConvertStr.decryptText((String)lockInfo, (String)this.key);
    }

    public boolean isLockEnabled(@NotNull LockCode lockCode) {
        if (lockCode.isPublicized()) {
            return true;
        }
        return this.isLockEnabled(lockCode.getCode());
    }

    private boolean isLockEnabled(int lockCode) {
        if (this.lockInfo.isEmpty()) {
            return true;
        }
        return this.lockInfo.startsWith("-1", lockCode * 2 - 2);
    }

    public String getKey() {
        return this.key;
    }
}

