/*
 * Decompiled with CFR 0.152.
 */
package com.utility;

import com.android.core.domain.model.BaseError;
import com.utility.ConvertStr;
import com.utility.TncExceptionMessages;
import com.utility.TncLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TncException
extends RuntimeException {
    private final Map<String, Object> model = new LinkedHashMap();
    private final List<TncException> exceptions = new ArrayList();
    private final List<Map<String, Object>> success = new ArrayList();
    private final TncLog log = new TncLog();
    private String message;
    private int errorCode;
    private TncExceptionMessages exception;
    private Runnable doOnError;

    public TncException(TncExceptionMessages exceptionMessage) {
        this.message = exceptionMessage.getMessage();
        this.errorCode = exceptionMessage.getCode();
        this.exception = exceptionMessage;
        this.addArgsToMessage(exceptionMessage.getArgs());
        this.addSuffixes(exceptionMessage.getSuffixes());
    }

    public TncException(String message, int code) {
        this.message = message;
        this.errorCode = code;
    }

    public TncException(List<TncException> list) {
        this.exceptions.addAll(list);
    }

    public static TncException fromException(Throwable t) {
        TncException e = t instanceof TncException ? (TncException)t : new TncException(TncExceptionMessages.DEFAULT_ERROR);
        e.putMoreInfo("errorMessage", (Object)t.getMessage());
        return e;
    }

    public TncException addSuccessList(List<Map<String, Object>> successList) {
        this.success.addAll(successList);
        return this;
    }

    public List<Map<String, Object>> getSuccessList() {
        return this.success;
    }

    public List<Map<String, Object>> makeFailureList() {
        if (this.exceptions.isEmpty()) {
            return Collections.singletonList(this.getErrorMap());
        }
        return this.exceptions.stream().map(e -> {
            if (e.getDoOnError() != null) {
                e.getDoOnError().run();
            }
            return e.getErrorMap();
        }).collect(Collectors.toList());
    }

    @Override
    public synchronized Throwable getCause() {
        return new Throwable(this.message);
    }

    private void addArgsToMessage(List<Object> args) {
        if (args.isEmpty()) {
            return;
        }
        this.message = String.format(this.message, args.toArray());
    }

    private void addSuffixes(List<Object> suffixes) {
        if (suffixes.isEmpty()) {
            return;
        }
        this.message = this.message + " " + ConvertStr.bindStrings((Collection)suffixes.stream().map(String::valueOf).collect(Collectors.toList()), (String)",");
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void putMoreInfo(String key, Object value) {
        this.model.put(key, value);
    }

    public Map<String, Object> getErrorMap() {
        this.model.put("Error", this.message);
        this.model.put("ErrorCode", this.errorCode);
        return this.model;
    }

    public BaseError makeAndroidError() {
        BaseError error = new BaseError().setMessage(this.message).setErrorCode(String.valueOf(this.errorCode));
        this.log.info("responseError = " + this.message + "\n" + this.model);
        if (this.model.containsKey("id")) {
            error.setEntityId(String.valueOf(this.model.remove("id")));
        }
        if (!this.model.isEmpty()) {
            error.setAdditionalInfo(this.model);
        }
        return error;
    }

    public Map<String, Object> makeErrorWithCause(Throwable e) {
        Map model = this.getErrorMap();
        model.put("Error", this.getMessage() + " \n " + e.getCause());
        return model;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public TncExceptionMessages getException() {
        return this.exception;
    }

    public void setDoOnError(Runnable doOnError) {
        this.doOnError = doOnError;
    }

    public Runnable getDoOnError() {
        return this.doOnError;
    }
}

