/*
 * Decompiled with CFR 0.152.
 */
package com.webhook;

import com.dto.LoginDto;
import com.utility.DbConnection;
import com.utility.DbLogin;
import com.webhook.DebeziumConnectorConfig;
import com.webhook.events.ChangeEventManager;
import io.debezium.config.Configuration;
import io.debezium.embedded.Connect;
import io.debezium.engine.DebeziumEngine;
import io.debezium.engine.RecordChangeEvent;
import io.debezium.engine.format.ChangeEventFormat;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.annotation.PreDestroy;
import org.apache.kafka.connect.source.SourceRecord;
import org.springframework.stereotype.Component;

@Component
public class CDCEngineHandler {
    private final Executor executor = Executors.newSingleThreadExecutor();
    private final DbConnection dbConnection;
    private final DebeziumConnectorConfig config;
    private DebeziumEngine<RecordChangeEvent<SourceRecord>> engine;
    public boolean isConnectorStarted = false;

    public CDCEngineHandler(DbConnection dbConnection, DebeziumConnectorConfig config) {
        this.dbConnection = dbConnection;
        this.config = config;
    }

    public boolean isEngineRunning() {
        return this.engine != null;
    }

    public void restartConnector(LoginDto loginDto) throws IOException {
        Configuration configuration = this.config.connect(loginDto);
        if (configuration == null) {
            return;
        }
        this.stop();
        DbLogin.getInstance((DbConnection)this.dbConnection, (LoginDto)loginDto);
        ChangeEventManager eventManager = new ChangeEventManager();
        this.engine = DebeziumEngine.create((ChangeEventFormat)ChangeEventFormat.of(Connect.class)).using(configuration.asProperties()).using((DebeziumEngine.ConnectorCallback)new /* Unavailable Anonymous Inner Class!! */).notifying((arg_0, arg_1) -> ((ChangeEventManager)eventManager).handleNotification(arg_0, arg_1)).build();
        this.start();
    }

    private void start() {
        this.executor.execute((Runnable)this.engine);
    }

    @PreDestroy
    public void stop() throws IOException {
        if (this.engine != null) {
            this.engine.close();
        }
    }
}

