/*
 * Decompiled with CFR 0.152.
 */
package com.webhook.events;

import com.utility.DbConnection;
import com.utility.DbLogin;
import com.webhook.events.ChangeStructParser;
import com.webhook.notifs.CDCBaseNotification;
import com.webhook.util.CDCTables;
import io.debezium.data.Envelope;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.springframework.jdbc.core.JdbcTemplate;

public abstract class BaseChangeFieldGenerator {
    private final DbLogin dbLogin;
    protected Map<String, Object> changedFields = new HashMap();

    public BaseChangeFieldGenerator(DbLogin dbLogin) {
        this.dbLogin = dbLogin;
    }

    public Map<String, Object> generateChangedFields(@NotNull CDCBaseNotification notification) throws InterruptedException {
        Envelope.Operation operation = notification.getOperation();
        ChangeStructParser parser = notification.getParser();
        CDCTables changedTable = parser.getChangedTable();
        if (operation.equals((Object)Envelope.Operation.UPDATE) && !this.mustUpdateAndAddChangedFields(parser)) {
            throw new InterruptedException("fields are all the same no need to send notification.");
        }
        if (operation.equals((Object)Envelope.Operation.DELETE)) {
            this.addToChangedFields(parser.getBeforePayload(), changedTable);
        } else if (operation.equals((Object)Envelope.Operation.CREATE)) {
            this.addToChangedFields(parser.getAfterPayload(), changedTable);
        }
        return this.changedFields;
    }

    private boolean mustUpdateAndAddChangedFields(@NotNull ChangeStructParser parser) {
        Map afterPayload = parser.getAfterPayload();
        Set afterSet = afterPayload.keySet();
        Map beforePayload = parser.getBeforePayload();
        HashMap afterObjects = new HashMap();
        for (String key : afterSet) {
            Object beforeField;
            Object afterField = afterPayload.get(key);
            if (afterField.equals(beforeField = beforePayload.get(key))) continue;
            afterObjects.put(key, afterField);
        }
        if (afterObjects.isEmpty()) {
            return false;
        }
        CDCTables changedTable = parser.getChangedTable();
        afterObjects.putAll(this.getCodeFieldsMap(afterPayload, changedTable));
        this.addToChangedFields(afterObjects, changedTable);
        return true;
    }

    @NotNull
    private Map<String, Object> getCodeFieldsMap(Map<String, Object> afterPayload, @NotNull CDCTables changedTable) {
        String[] codeFields = changedTable.getTableCodeField();
        HashMap<String, Object> codeMap = new HashMap<String, Object>();
        for (String codeField : codeFields) {
            codeMap.put(codeField.toLowerCase(), afterPayload.get(codeField.toLowerCase()));
        }
        return codeMap;
    }

    public DbConnection getDbConnection() {
        return this.dbLogin.getDbConnection();
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.getDbConnection().getJdbcTemplate(this.dbLogin.getLogin());
    }

    protected abstract void addToChangedFields(Map<String, Object> var1, CDCTables var2);

    public List<CDCBaseNotification> mergeNotifications(List<CDCBaseNotification> notifications) {
        return null;
    }
}

