/*
 * Decompiled with CFR 0.152.
 */
package com.webhook.events;

import com.webhook.events.ChangeStructParser;
import com.webhook.notifs.CDCBaseNotification;
import io.debezium.data.Envelope;
import io.debezium.engine.DebeziumEngine;
import io.debezium.engine.RecordChangeEvent;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;

public class ChangeEventParser {
    public CDCBaseNotification parse(RecordChangeEvent<SourceRecord> changeRecord, DebeziumEngine.RecordCommitter<RecordChangeEvent<SourceRecord>> committer) throws InterruptedException {
        CDCBaseNotification notification = this.parseRecord(changeRecord);
        committer.markProcessed(changeRecord);
        return notification;
    }

    private CDCBaseNotification parseRecord(RecordChangeEvent<SourceRecord> changeRecord) {
        Struct recordChangeValue = this.getChangeStruct(changeRecord);
        if (recordChangeValue == null) {
            return null;
        }
        Envelope.Operation operation = Envelope.Operation.forCode((String)((String)recordChangeValue.get("op")));
        if (!operation.equals((Object)Envelope.Operation.READ)) {
            ChangeStructParser structParser = new ChangeStructParser(recordChangeValue);
            return new CDCBaseNotification(structParser, operation);
        }
        return null;
    }

    private Struct getChangeStruct(RecordChangeEvent<SourceRecord> changeRecord) {
        SourceRecord sourceRecord = (SourceRecord)changeRecord.record();
        return (Struct)sourceRecord.value();
    }
}

