/*
 * Decompiled with CFR 0.152.
 */
package com.webhook.events;

import com.utility.ConvertStr;
import com.utility.DbLogin;
import com.webhook.events.BaseChangeFieldGenerator;
import com.webhook.events.PictureType;
import com.webhook.events.PictureWebhookUtils;
import com.webhook.notifs.CDCBaseNotification;
import com.webhook.util.CDCTables;
import com.webhook.util.ColumnNameChanger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HLOPictureChangeField
extends BaseChangeFieldGenerator {
    protected Map<String, Object> data = new HashMap();

    HLOPictureChangeField(DbLogin dbLogin) {
        super(dbLogin);
    }

    protected void addToChangedFields(Map<String, Object> payload, CDCTables changedTable) {
        this.data = ColumnNameChanger.getFakedColumnsPayload(payload, (CDCTables)changedTable);
        try {
            String picture = null;
            if (this.data.get("Image") instanceof byte[]) {
                picture = ConvertStr.base64encodeNoLineBreak((byte[])((byte[])this.data.get("Image")));
            } else if (this.data.get("Image") instanceof ByteBuffer) {
                picture = ConvertStr.base64encodeNoLineBreak((byte[])((ByteBuffer)this.data.get("Image")).array());
            }
            ArrayList<String> images = new ArrayList<String>();
            if (!ConvertStr.isNullOrEmpty((String)picture) && !picture.equals("MA==")) {
                images.add(picture);
            }
            ArrayList<String> imagePathList = new ArrayList<String>();
            imagePathList.add(this.data.get("ImagePath").toString());
            int type = (Integer)this.data.get("Type");
            PictureType pictureType = PictureType.fromType((int)type);
            this.changedFields.put("ErpCode", this.data.get("ErpCode"));
            this.changedFields.put("Image", images);
            this.changedFields.put("ImagePath", imagePathList);
            this.changedFields.put("Table", pictureType.name().toLowerCase());
            this.changedFields.put("ID", this.data.get("ID"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<CDCBaseNotification> mergeNotifications(List<CDCBaseNotification> notifications) {
        return PictureWebhookUtils.INSTANCE.mergeNotifications(notifications);
    }
}

