/*
 * Decompiled with CFR 0.152.
 */
package com.webhook.events;

import com.utility.ConvertStr;
import com.utility.DbLogin;
import com.webhook.events.BaseChangeFieldGenerator;
import com.webhook.notifs.CDCBaseNotification;
import com.webhook.util.CDCTables;
import com.webhook.util.ColumnNameChanger;
import io.debezium.data.Envelope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.jdbc.support.rowset.SqlRowSet;

public class PreInvoiceChangeField
extends BaseChangeFieldGenerator {
    PreInvoiceChangeField(DbLogin dbLogin) {
        super(dbLogin);
    }

    protected void addToChangedFields(Map<String, Object> payload, CDCTables changedTable) {
        this.changedFields = ColumnNameChanger.getFakedColumnsPayload(payload, (CDCTables)changedTable);
        this.addPreInvoiceDtlData();
        this.addPreInvoiceData();
    }

    private void addPreInvoiceDtlData() {
        SqlRowSet rs = this.getJdbcTemplate().queryForRowSet(" SELECT DISTINCT ROUND(W.[EXIST], 3) [fewTak], ROUND(V.[EXIST], 3) [fewSpd], A.Exist few \n FROM W_ShowArticleForSearch_Big W \n LEFT JOIN W_GETEXISTARTICLE V ON V.A_CODE = W.A_CODE \n JOIN Article A ON V.A_CODE = A.A_CODE WHERE W.A_CODE = ?", new Object[]{ConvertStr.decrypt((String)((String)this.changedFields.get("ProductErpCode")))});
        if (!rs.next()) {
            return;
        }
        double few = (Double)this.changedFields.get("Few") / (Double)this.changedFields.get("Unit_Few");
        this.changedFields.put("Few", few);
        double sumPrice = (Double)this.changedFields.get("Few") * (Double)this.changedFields.get("Price");
        this.changedFields.put("SumPrice", sumPrice);
        this.changedFields.put("fewTak", rs.getDouble("fewTak"));
        this.changedFields.put("fewSpd", rs.getDouble("fewSpd"));
    }

    private void addPreInvoiceData() {
        StringBuilder cols = new StringBuilder();
        for (int i = 0; i < CDCTables.PRE_INVOICE.getCols().length; ++i) {
            cols.append(CDCTables.PRE_INVOICE.getCols()[i]);
            if (i == CDCTables.PRE_INVOICE.getCols().length - 1) continue;
            cols.append(", ");
        }
        String sql = "SELECT " + cols + " FROM FBailPre WHERE Fac_Code = '" + ConvertStr.decrypt((String)((String)this.changedFields.get("Fac_Code"))) + "' AND Fac_Type = '" + this.changedFields.get("Fac_Type") + "'";
        Map<String, Boolean> preInvoice = new HashMap();
        Map data = new HashMap();
        try {
            data = this.getJdbcTemplate().queryForMap(sql);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!data.isEmpty()) {
            preInvoice = ColumnNameChanger.getFakedColumnsPayload(data, (CDCTables)CDCTables.PRE_INVOICE);
            preInvoice.put("isPreInvoiceDeleted", false);
        } else {
            preInvoice.put("ErpCode", (Boolean)this.changedFields.get("Fac_Code"));
            preInvoice.put("invoiceType", (Boolean)this.changedFields.get("Fac_Type"));
            preInvoice.put("isPreInvoiceDeleted", true);
        }
        this.changedFields.put("preInvoice", preInvoice);
    }

    public List<CDCBaseNotification> mergeNotifications(List<CDCBaseNotification> notifications) {
        try {
            CDCBaseNotification toAddNotification = null;
            ArrayList<CDCBaseNotification> preInvoiceNotifications = new ArrayList<CDCBaseNotification>();
            for (CDCBaseNotification notification : notifications) {
                if (!notification.getChangedTableName().equalsIgnoreCase("dbo.ABailPre")) continue;
                preInvoiceNotifications.add(notification);
            }
            HashSet deletedRows = new HashSet();
            HashSet createdRows = new HashSet();
            ArrayList<Map> commonItems = new ArrayList<Map>();
            for (CDCBaseNotification notification : preInvoiceNotifications) {
                if (notification.getOperation() == Envelope.Operation.DELETE) {
                    deletedRows.addAll(notification.getAllChangedRows());
                    continue;
                }
                if (notification.getOperation() != Envelope.Operation.CREATE) continue;
                createdRows.addAll(notification.getAllChangedRows());
            }
            for (Map created : createdRows) {
                for (Map deleted : deletedRows) {
                    if (!created.get("Fac_Code").equals(deleted.get("Fac_Code")) || !created.get("Fac_Type").equals(deleted.get("Fac_Type")) || !created.get("ProductErpCode").equals(deleted.get("ProductErpCode"))) continue;
                    commonItems.add(created);
                }
            }
            if (!commonItems.isEmpty()) {
                for (CDCBaseNotification notification : preInvoiceNotifications) {
                    for (Map item : commonItems) {
                        notification.getAllChangedRows().removeIf(toDelete -> toDelete.get("Fac_Code").equals(item.get("Fac_Code")) && toDelete.get("Fac_Type").equals(item.get("Fac_Type")) && toDelete.get("ProductErpCode").equals(item.get("ProductErpCode")));
                    }
                }
                toAddNotification = new CDCBaseNotification(((CDCBaseNotification)preInvoiceNotifications.get(0)).getParser(), Envelope.Operation.UPDATE);
                toAddNotification.setChangedTableName(CDCTables.PRE_INVOICE_DETAIL.getFinalChangeTableName());
                toAddNotification.getAllChangedRows().addAll(commonItems);
                preInvoiceNotifications.add(toAddNotification);
            }
            this.fixPreInvoiceStructure(preInvoiceNotifications);
            ArrayList<CDCBaseNotification> baseNotifications = new ArrayList<CDCBaseNotification>();
            baseNotifications.add(toAddNotification);
            return baseNotifications;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void fixPreInvoiceStructure(List<CDCBaseNotification> preInvoiceNotifications) {
        for (CDCBaseNotification notification : preInvoiceNotifications) {
            Map<Object, List<Map>> groupBy = notification.getAllChangedRows().stream().collect(Collectors.groupingBy(map -> map.get("Fac_Code")));
            notification.getAllChangedRows().clear();
            groupBy.forEach((facCode, data) -> {
                HashMap<String, Object[]> preInvoice = new HashMap<String, Object[]>();
                ArrayList dtlArray = new ArrayList();
                data.forEach(created -> {
                    preInvoice.putAll((Map)created.get("preInvoice"));
                    HashMap dtl = new HashMap(created);
                    dtl.remove("preInvoice");
                    dtlArray.add(dtl);
                });
                preInvoice.put("dtl", dtlArray.toArray());
                notification.getAllChangedRows().add(preInvoice);
            });
        }
    }
}

