/*
 * Decompiled with CFR 0.152.
 */
package com.webhook.events;

import com.utility.ConvertStr;
import com.utility.DbLogin;
import com.webhook.events.BaseChangeFieldGenerator;
import com.webhook.events.ProductWebhookUtils;
import com.webhook.notifs.CDCBaseNotification;
import com.webhook.util.CDCTables;
import com.webhook.util.ColumnNameChanger;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.support.rowset.SqlRowSet;

public class ProductChangeField
extends BaseChangeFieldGenerator {
    private String aCode;
    private String mCode = null;
    private String sCode = null;

    ProductChangeField(DbLogin dbLogin) {
        super(dbLogin);
    }

    protected void addToChangedFields(Map<String, Object> payload, CDCTables changedTable) {
        this.aCode = String.valueOf(payload.get("a_code"));
        this.changedFields = ColumnNameChanger.getFakedColumnsPayload(payload, (CDCTables)changedTable);
        try {
            this.assignMainGroupCode();
            this.assignSideGroupCode();
            this.addCommonNamesToChangedFieldsMap();
            this.convertDate();
        }
        catch (Exception e) {
            return;
        }
        this.addGroupsErp();
        this.replaceExist();
    }

    private void convertDate() {
        if (this.changedFields.containsKey("date")) {
            SqlRowSet rs = this.getJdbcTemplate().queryForRowSet(" SELECT dbo.MiladiToShamsi(Finish_Date) date FROM Article WHERE A_CODE = ?", new Object[]{this.aCode});
            if (!rs.next()) {
                return;
            }
            this.changedFields.put("date", rs.getString("date"));
        }
    }

    private void addCommonNamesToChangedFieldsMap() {
        SqlRowSet rs = this.getJdbcTemplate().queryForRowSet(" SELECT DISTINCT M_GROUPNAME MGN, S_GROUPNAME SGN, A_NAME, A_Code_C  FROM W_SHOWARTICLEFORSEARCH_BIG WHERE A_CODE = ?", new Object[]{this.aCode});
        if (!rs.next()) {
            return;
        }
        this.changedFields.put("Name", rs.getString("A_NAME"));
        this.changedFields.put("Code", rs.getString("A_Code_C"));
        this.changedFields.put("SideGroupName", rs.getString("SGN"));
        this.changedFields.put("MainGroupName", rs.getString("MGN"));
    }

    private void addGroupsErp() {
        this.changedFields.put("MainGroupErpCode", ConvertStr.encrypt((String)this.mCode));
        this.changedFields.put("SideGroupErpCode", ConvertStr.encrypt((String)this.sCode));
    }

    private void assignMainGroupCode() throws IndexOutOfBoundsException {
        this.mCode = this.aCode.substring(0, 2);
    }

    private void assignSideGroupCode() throws IndexOutOfBoundsException {
        this.sCode = this.aCode.substring(0, 4);
    }

    private void replaceExist() {
        String aCode = (String)this.changedFields.get(CDCTables.PRODUCT.getTableCodeFieldToShow());
        aCode = ConvertStr.decrypt((String)aCode);
        SqlRowSet rs = this.getJdbcTemplate().queryForRowSet(" SELECT DISTINCT ROUND(W.[EXIST], 3) [fewTak], ROUND(V.[EXIST], 3) [fewSpd] \n FROM W_ShowArticleForSearch_Big W \n LEFT JOIN W_GETEXISTARTICLE V ON V.A_CODE = W.A_CODE \n WHERE W.A_CODE = ?", new Object[]{aCode});
        if (!rs.next()) {
            return;
        }
        this.changedFields.put("fewTak", rs.getDouble("fewTak"));
        this.changedFields.put("fewSpd", rs.getDouble("fewSpd"));
    }

    public List<CDCBaseNotification> mergeNotifications(List<CDCBaseNotification> notifications) {
        return ProductWebhookUtils.INSTANCE.mergeNotifications(notifications);
    }
}

