/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.tzupdater;

import com.sun.tools.tzupdater.DataConfiguration;
import com.sun.tools.tzupdater.ExternalModule;
import com.sun.tools.tzupdater.Logger;
import com.sun.tools.tzupdater.Messages;
import com.sun.tools.tzupdater.TzRuntimeException;
import com.sun.tools.tzupdater.TzupdaterException;
import com.sun.tools.tzupdater.Verifier;
import com.sun.tools.tzupdater.converter.VanguardToRearguardConverter;
import com.sun.tools.tzupdater.utils.UtilsHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class TimezoneUpdater {
    private static final String TZDATA_FILE = "dynamic_tzdata.zip";
    private static final String COMPAT_SUFFIX = ".compat";
    private static final String TEST_SUFFIX = ".test";
    private static final String SCRIPT_NAME = "pkg_resolve.sh";
    private static final String TZDB_RESOURCE_PATH = "/data/tzdb.dat";
    private static final String DEFAULT_URL = "https://www.iana.org/time-zones/repository/tzdata-latest.tar.gz";
    private static final boolean IS_FORCE_USE_OF_VANGUARD = TimezoneUpdater.forceUseOfVanguard();
    private static final int BUFSIZE = 8192;
    private final String vendor = System.getProperty("java.vendor");
    private final String jreVersion = System.getProperty("java.version");
    private final String javaHome = System.getProperty("java.home");
    private final String osName = System.getProperty("os.name");
    private static String currentID = "";
    private static boolean helpOnly;
    private static boolean showVersionOnly;
    private static boolean performUpdate;
    private static boolean forceUpdate;
    private static boolean jsr310;
    private static boolean verbose;
    private static String url;
    private static File tmpDynamicDir;

    public TimezoneUpdater(String[] stringArray, PrintStream printStream) {
        if (stringArray.length == 0) {
            helpOnly = true;
        }
        for (String string : stringArray) {
            if (!string.equals("-v") && !string.equals("--verbose")) continue;
            verbose = true;
            break;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.equals("-h") || string.equals("--help")) {
                helpOnly = true;
                return;
            }
            if (string.equals("-V") || string.equals("--version")) {
                if (stringArray.length > 1) {
                    helpOnly = true;
                    break;
                }
                showVersionOnly = true;
                break;
            }
            if (string.equals("-f") || string.equals("--force")) {
                performUpdate = true;
                forceUpdate = true;
                continue;
            }
            if (string.equals("-v") || string.equals("--verbose")) continue;
            if (string.equals("-l") || string.equals("--location") || string.equals("-u") || string.equals("--update")) {
                if (i != stringArray.length - 1 && !stringArray[i + 1].startsWith("-")) {
                    url = stringArray[++i];
                }
                performUpdate = true;
                continue;
            }
            Logger.init(true, printStream);
            Logger.error(Messages.printf("unknown.flag", string));
            Logger.error(Messages.printf("usage", string));
            throw new TzRuntimeException();
        }
        if (performUpdate && showVersionOnly || !performUpdate && verbose) {
            helpOnly = true;
        }
        if (showVersionOnly) {
            verbose = true;
        }
        if (performUpdate && !helpOnly) {
            Logger.init(true, printStream);
            Logger.println(Messages.printf("using.url", url));
        }
        Logger.init(verbose, printStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        if (helpOnly) {
            System.out.println(Messages.printf("usage"));
            return;
        }
        if (!showVersionOnly) {
            Logger.println(Messages.printf("java.home", this.javaHome));
            Logger.println(Messages.printf("java.vendor", this.vendor));
            Logger.println(Messages.printf("java.version", this.jreVersion));
        }
        Logger.println("tzupdater version 2.3.2-b02");
        try {
            Object object = null;
            String string = UtilsHelper.toTzdbFileName(this.javaHome);
            if (string != null) {
                jsr310 = true;
            }
            if (!TimezoneUpdater.isJSR310()) {
                object = UtilsHelper.toZiDirName(this.javaHome);
                if (object == null) {
                    throw new TzRuntimeException(Messages.printf("no.zi"));
                }
                currentID = UtilsHelper.getTzID((String)object);
            } else {
                currentID = UtilsHelper.getTzIDFromTZDB(string);
            }
            Logger.println(Messages.printf("jre.tzdata.version", currentID));
            tmpDynamicDir = TimezoneUpdater.getTempDir(System.getProperty("java.io.tmpdir"));
            String string2 = ExternalModule.downloadFile(url, tmpDynamicDir + File.separator + "tzdata.tar.gz", showVersionOnly);
            ExternalModule.extractFiles(string2);
            if (!TimezoneUpdater.isJSR310() && !IS_FORCE_USE_OF_VANGUARD) {
                VanguardToRearguardConverter.convert(tmpDynamicDir);
            }
            DataConfiguration dataConfiguration = DataConfiguration.getDataConfiguration(tmpDynamicDir);
            String string3 = dataConfiguration.getTzID();
            Logger.println(Messages.printf("tool.tzdata.version", string3));
            if (showVersionOnly) {
                return;
            }
            ExternalModule.createVersionFile(tmpDynamicDir.getPath(), string3);
            if (TimezoneUpdater.isJSR310()) {
                ExternalModule.compileToJSRBinary(tmpDynamicDir.getPath(), string + ".dynamic");
            } else {
                ExternalModule.compileToZiBinary(string3, tmpDynamicDir.getPath());
            }
            this.checkIfSameVersion(string3);
            if (!TimezoneUpdater.isJSR310()) {
                this.update((String)object, currentID, dataConfiguration);
            } else {
                this.updateTzDB(string + ".dynamic");
            }
            ExternalModule.compileTestFiles(tmpDynamicDir + File.separator + "tzdata.test.dynamic");
            this.verify(dataConfiguration, tmpDynamicDir + File.separator + "tzdata.test.dynamic");
            Logger.println(Messages.printf("state.complete", string3));
        }
        catch (TzupdaterException tzupdaterException) {
            if (!showVersionOnly) {
                throw tzupdaterException;
            }
        }
        finally {
            File file;
            TimezoneUpdater.remove(tmpDynamicDir);
            if (TimezoneUpdater.isJSR310() && (file = new File(UtilsHelper.toTzdbFileName(this.javaHome) + ".dynamic")).exists()) {
                file.delete();
            }
        }
    }

    private void update(String string, String string2, DataConfiguration dataConfiguration) throws IOException {
        String string3 = dataConfiguration.getTzID();
        File file = new File(string);
        File file2 = file.getParentFile();
        if (!file2.canWrite()) {
            throw new TzRuntimeException(Messages.printf("not.writable", file2.getAbsolutePath()));
        }
        File file3 = TimezoneUpdater.getUniqueFile(string, string3);
        try {
            this.extract(file3, tmpDynamicDir + File.separator + TZDATA_FILE);
        }
        catch (IOException iOException) {
            TimezoneUpdater.remove(file3);
            throw iOException;
        }
        Object var8_9 = null;
        File file4 = TimezoneUpdater.getUniqueFile(string, string2);
        Logger.println(Messages.printf("state.renaming", file.getPath(), file4.getPath()));
        if (!file.renameTo(file4)) {
            TimezoneUpdater.remove(file3);
            Logger.println(Messages.printf("state.failed"));
            throw new TzRuntimeException(Messages.printf("error.cannot.rename", file, file4));
        }
        Logger.println(Messages.printf("state.renaming", file3.getPath(), file.getPath()));
        if (!file3.renameTo(file)) {
            Logger.println(Messages.printf("state.failed"));
            Logger.error(Messages.printf("error.cannot.rename", file3, file));
            Logger.print(Messages.printf("state.restoring"));
            if (file4.renameTo(file)) {
                TimezoneUpdater.remove(file3);
                throw new TzRuntimeException(Messages.printf("state.done"));
            }
            Logger.println();
            throw new TzRuntimeException(Messages.printf("error.cannot.restore", file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTzDB(String string) {
        File file = null;
        try {
            File file2 = new File(this.javaHome, "lib");
            if (!file2.exists()) {
                file2 = new File(this.javaHome + File.separator + "jre" + File.separator + "lib");
            }
            file = TimezoneUpdater.getTempDir(file2.getAbsolutePath());
            File file3 = new File(file2, "tzdb.dat");
            File file4 = new File(file2, "tzdb.dat." + currentID);
            Logger.println(Messages.printf("state.renaming", file3.getPath(), file4.getPath()));
            if (!file3.renameTo(file4)) {
                Logger.println(Messages.printf("state.failed"));
                throw new TzRuntimeException(Messages.printf("error.cannot.rename", file3, file4));
            }
            File file5 = new File(string);
            Logger.println(Messages.printf("state.renaming", file5.getPath(), file3.getPath()));
            if (!file5.renameTo(file3)) {
                Logger.println(Messages.printf("state.failed"));
                throw new TzRuntimeException(Messages.printf("error.cannot.rename", file5, file3));
            }
            TimezoneUpdater.remove(file);
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            if (string2 != null) {
                Logger.error(string2);
            }
        }
        finally {
            TimezoneUpdater.remove(file);
        }
    }

    private void checkIfSameVersion(String string) {
        if (!forceUpdate) {
            int n = currentID.compareTo(string);
            if (n == 0) {
                throw new TzRuntimeException(Messages.printf("tzdata.version.same", string));
            }
            if (n > 0) {
                throw new TzRuntimeException(Messages.printf("tzdata.version.later", currentID, string));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extract(File file, String string) throws IOException {
        InputStream inputStream = null;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(new File(string));
            this.extractFromZipFile(file, zipFile);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    private void extractFromZipFile(File file, ZipFile zipFile) throws IOException {
        InputStream inputStream = null;
        Logger.print(Messages.printf("state.extracting"));
        if (!file.mkdirs()) {
            Logger.println(Messages.printf("state.failed"));
            throw new IOException(Messages.printf("error.cannot.mkdir", file));
        }
        ArrayList<ZipEntry> arrayList = new ArrayList<ZipEntry>(64);
        byte[] byArray = new byte[8192];
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            File file2;
            ZipEntry zipEntry;
            block18: {
                FileOutputStream object;
                zipEntry = enumeration.nextElement();
                file2 = new File(file, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    if (!file2.mkdirs()) {
                        Logger.println(Messages.printf("state.failed"));
                        throw new IOException(Messages.printf("error.cannot.mkdir", file2));
                    }
                    arrayList.add(zipEntry);
                    continue;
                }
                OutputStream outputStream = null;
                try {
                    object = new FileOutputStream(file2);
                    inputStream = zipFile.getInputStream(zipEntry);
                    this.copy(inputStream, object, zipEntry.getSize(), byArray);
                    if (object == null) break block18;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    try {
                        Logger.println(Messages.printf("state.failed"));
                        throw fileNotFoundException;
                    }
                    catch (Throwable throwable) {
                        if (outputStream != null) {
                            outputStream.close();
                        }
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        throw throwable;
                    }
                }
                ((OutputStream)object).close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
            try {
                file2.setWritable(true, true);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            file2.setLastModified(zipEntry.getTime());
            file2.setReadOnly();
            try {
                file2.setExecutable(false);
            }
            catch (NoSuchMethodError noSuchMethodError) {}
        }
        for (ZipEntry zipEntry : arrayList) {
            File noSuchMethodError = new File(file, zipEntry.getName());
            try {
                noSuchMethodError.setWritable(true, true);
            }
            catch (NoSuchMethodError noSuchMethodError2) {
                // empty catch block
            }
            noSuchMethodError.setLastModified(zipEntry.getTime());
        }
        Logger.println(Messages.printf("state.done"));
    }

    private void extractFile(File file, String string) throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            throw new TzupdaterException(string + " not found in bundle");
        }
        Logger.print(Messages.printf("state.extracting"));
        byte[] byArray = new byte[8192];
        File file2 = new File(file, string);
        Logger.println("Creating: " + file + File.separator + ": " + string);
        OutputStream outputStream = null;
        try {
            if (string.lastIndexOf(47) > 0) {
                File file3 = new File(file2.getParent());
                if (file3.mkdirs()) {
                    Logger.println("Need to make dir " + file3.getAbsolutePath());
                } else {
                    Logger.error("Failed to make dir " + file3.getAbsolutePath());
                    throw new IOException("cannot make directory " + file3.getAbsolutePath());
                }
            }
            outputStream = new FileOutputStream(file2);
            this.copy(inputStream, outputStream, byArray);
            Logger.println(Messages.printf("state.done"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.error(Messages.printf("state.failed"));
            throw fileNotFoundException;
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private void verify(DataConfiguration dataConfiguration, String string) throws IOException {
        List list = null;
        Logger.println(Messages.printf("state.validating", dataConfiguration.getTzID()));
        String string2 = string;
        if (!Verifier.run(string2, list)) {
            Logger.println();
            throw new TzRuntimeException(Messages.printf("state.validation.failed"));
        }
        Logger.println(Messages.printf("state.validation.complete"));
        this.correctPackageDB();
    }

    private void copy(InputStream inputStream, OutputStream outputStream, long l, byte[] byArray) throws IOException {
        int n;
        while (l > 0L && (n = inputStream.read(byArray, 0, Math.min((int)l, byArray.length))) > 0) {
            outputStream.write(byArray, 0, n);
            l -= (long)n;
        }
    }

    public static void remove(File file) {
        File[] fileArray;
        if (file == null || !file.exists()) {
            return;
        }
        for (File file2 : fileArray = file.listFiles()) {
            if (file2.isDirectory()) {
                TimezoneUpdater.remove(file2);
                continue;
            }
            file2.delete();
        }
        file.delete();
    }

    private void copy(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        int n;
        while (inputStream.available() > 0 && (n = inputStream.read(byArray, 0, Math.min(inputStream.available(), byArray.length))) > 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    private static File getUniqueFile(String string, String string2) {
        File file = new File(string + "." + string2);
        if (file.exists()) {
            int n = 1;
            while ((file = new File(string + "." + string2 + "_" + n++)).exists()) {
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void correctPackageDB() throws IOException {
        BufferedReader bufferedReader;
        File file;
        block16: {
            if (!this.osName.toLowerCase().startsWith("sunos")) {
                return;
            }
            file = null;
            InputStream inputStream = null;
            InputStreamReader inputStreamReader = null;
            bufferedReader = null;
            try {
                String string;
                File file2 = new File(this.javaHome, "lib");
                if (!file2.exists()) {
                    file2 = new File(this.javaHome + File.separator + "jre" + File.separator + "lib");
                }
                file = TimezoneUpdater.getTempDir(file2.getAbsolutePath());
                this.extractFile(file, "/pkg_resolve.sh");
                File file3 = new File(this.javaHome, "bin");
                if (!file3.exists()) {
                    file3 = new File(this.javaHome + File.separator + "jre" + File.separator + "bin");
                }
                Runtime runtime = Runtime.getRuntime();
                Process process = runtime.exec("/bin/ksh " + file.getAbsolutePath() + "/" + SCRIPT_NAME + " " + file3 + File.separator + "java");
                inputStream = process.getInputStream();
                inputStreamReader = new InputStreamReader(inputStream);
                bufferedReader = new BufferedReader(inputStreamReader);
                while ((string = bufferedReader.readLine()) != null) {
                    System.out.println(string);
                }
                try {
                    if (process.waitFor() != 0) {
                        System.err.println("exit value = " + process.exitValue());
                    }
                }
                catch (InterruptedException interruptedException) {
                    System.err.println(interruptedException);
                }
                if (inputStreamReader == null) break block16;
            }
            catch (Exception exception) {
                block17: {
                    try {
                        String string = exception.getMessage();
                        if (string != null) {
                            Logger.error(string);
                        }
                        if (inputStreamReader == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (inputStreamReader != null) {
                            inputStreamReader.close();
                        }
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        TimezoneUpdater.remove(file);
                        throw throwable;
                    }
                    inputStreamReader.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                TimezoneUpdater.remove(file);
            }
            inputStreamReader.close();
        }
        if (bufferedReader != null) {
            bufferedReader.close();
        }
        TimezoneUpdater.remove(file);
    }

    private static File getTempDir(String string) {
        File file = TimezoneUpdater.getUniqueFile(string + File.separator + "tz", "tmp");
        boolean bl = file.mkdir();
        if (!bl) {
            throw new TzRuntimeException(Messages.printf("nocreate.tempdir", file.getAbsolutePath()));
        }
        return file;
    }

    static boolean getVerboseFlag() {
        return verbose && !showVersionOnly;
    }

    static boolean isJSR310() {
        return jsr310;
    }

    private static boolean forceUseOfVanguard() {
        PrivilegedAction<String> privilegedAction = new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("tzupdater.forceUseOfVanguard");
            }
        };
        String string = AccessController.doPrivileged(privilegedAction);
        if (string == null) {
            return false;
        }
        return string.isEmpty() || Boolean.parseBoolean(string);
    }

    public static void main(String[] stringArray) {
        try {
            TimezoneUpdater timezoneUpdater = new TimezoneUpdater(stringArray, null);
            timezoneUpdater.run();
            return;
        }
        catch (TzupdaterException tzupdaterException) {
            throw tzupdaterException;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            Throwable throwable = exception.getCause();
            if (string != null && (throwable != null && !(throwable instanceof TzRuntimeException) || exception instanceof TzRuntimeException)) {
                Logger.error(string);
            } else if (!(exception instanceof TzRuntimeException)) {
                Logger.error(exception.toString());
            }
            if (verbose) {
                throw new TzRuntimeException(exception);
            }
            System.exit(1);
            return;
        }
    }

    static {
        url = DEFAULT_URL;
        tmpDynamicDir = null;
    }
}

