/*
 * Decompiled with CFR 0.152.
 */
package tools.javazic;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import tools.javazic.BackEnd;
import tools.javazic.Mappings;
import tools.javazic.Timezone;
import tools.javazic.Zone;
import tools.javazic.Zoneinfo;

public class Main {
    private static boolean verbose = false;
    static boolean outputSrc = false;
    static boolean outputDoc = false;
    private List<String> ziFiles = new ArrayList<String>();
    private static String zoneNamesFile = null;
    private static String versionName = "unknown";
    private static String outputDir = "zoneinfo";
    private static String mapFile = null;

    Main() {
    }

    public Main(String string, String string2, String string3) {
        versionName = string;
        outputDir = string3;
        String[] stringArray = new String[]{"africa", "antarctica", "asia", "australasia", "europe", "northamerica", "pacificnew", "southamerica", "backward", "etcetera", "gmt", "jdk11_backward", "solar87", "solar88", "solar89"};
        for (int i = 0; i < stringArray.length; ++i) {
            this.ziFiles.add(string2 + File.separator + stringArray[i]);
        }
    }

    void processArgs(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.startsWith("-h")) {
                this.usage();
                System.exit(0);
                continue;
            }
            if (string.equals("-d")) {
                outputDir = stringArray[++i];
                continue;
            }
            if (string.equals("-v")) {
                verbose = true;
                continue;
            }
            if (string.equals("-V")) {
                versionName = stringArray[++i];
                continue;
            }
            if (string.equals("-source")) {
                outputSrc = true;
                continue;
            }
            if (string.equals("-doc")) {
                outputDoc = true;
                continue;
            }
            if (string.equals("-map")) {
                outputDoc = true;
                mapFile = stringArray[++i];
                continue;
            }
            if (string.equals("-f")) {
                zoneNamesFile = stringArray[++i];
                continue;
            }
            if (string.equals("-S")) {
                try {
                    Zoneinfo.setYear(Integer.parseInt(stringArray[++i]));
                }
                catch (Exception exception) {
                    Main.error("invalid year: " + stringArray[i]);
                    this.usage();
                    System.exit(1);
                }
                continue;
            }
            boolean bl = string.equals("-s");
            if (bl || string.equals("-e")) {
                try {
                    int n = Integer.parseInt(stringArray[++i]);
                    if (bl) {
                        Zoneinfo.setStartYear(n);
                        continue;
                    }
                    Zoneinfo.setEndYear(n);
                }
                catch (Exception exception) {
                    Main.error("invalid year: " + stringArray[i]);
                    this.usage();
                    System.exit(1);
                }
                continue;
            }
            while (i < stringArray.length) {
                this.ziFiles.add(stringArray[i++]);
            }
        }
    }

    public int compile() {
        int n = this.ziFiles.size();
        int n2 = 0;
        Mappings mappings = new Mappings();
        BackEnd backEnd = BackEnd.getBackEnd();
        for (int i = 0; i < n; ++i) {
            Zoneinfo zoneinfo = Zoneinfo.parse(this.ziFiles.get(i));
            if (zoneinfo == null) continue;
            for (String string : zoneinfo.getZones().keySet()) {
                Main.info(string);
                Timezone timezone = zoneinfo.phase2(string);
                n2 |= backEnd.processZoneinfo(timezone);
            }
            mappings.add(zoneinfo);
        }
        Zone.addMET();
        mappings.resolve();
        return n2 |= backEnd.generateSrc(mappings);
    }

    public static void main(String[] stringArray) {
        Main main = new Main();
        main.processArgs(stringArray);
        if (zoneNamesFile != null) {
            Zone.readZoneNames(zoneNamesFile);
        }
        int n = main.compile();
        System.exit(n);
    }

    void usage() {
        System.err.println("Usage: javazic [options] file...\n         -f namefile  file containing zone names\n                      to be generated (ie, generating subset)\n         -d dir       output directory\n         -v           verbose\n         -V datavers  specifies the tzdata version string\n                      (eg, \"tzdata2000g\")         -S year      output only SimleTimeZone data of that year\n         -s year      start year (default: 1900)\n         -e year      end year (default: 2037)\n         -source      generates java program files\n         -doc         generates HTML documents\n         -map mapfile generates HTML documents with map information\n         file...      zoneinfo source file(s)");
    }

    static String getOutputDir() {
        return outputDir;
    }

    static String getMapFile() {
        return mapFile;
    }

    static String getVersionName() {
        return versionName;
    }

    public static void panic(String string) {
        Main.printMessage("fatal error", string);
        System.exit(1);
    }

    static void error(String string) {
        Main.printMessage("error", string);
    }

    static void warning(String string) {
        Main.printMessage("warning", string);
    }

    static void info(String string) {
        if (verbose) {
            Main.printMessage(null, string);
        }
    }

    private static void printMessage(String string, String string2) {
        string = string != null ? string + ": " : "";
        System.err.println("javazic: " + string + string2);
    }
}

