/*
 * Decompiled with CFR 0.152.
 */
package tools.javazic;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import tools.javazic.BackEnd;
import tools.javazic.Main;
import tools.javazic.Mappings;
import tools.javazic.Month;
import tools.javazic.RuleRec;
import tools.javazic.Time;
import tools.javazic.Timezone;
import tools.javazic.Zone;
import tools.javazic.ZoneRec;

class Simple
extends BackEnd {
    private static Map<String, ZoneRec> lastZoneRecs = new HashMap<String, ZoneRec>();
    private static Map<String, List<RuleRec>> lastRules = new TreeMap<String, List<RuleRec>>();
    private static Map<String, Timezone> timezones = new HashMap<String, Timezone>();
    private SortedMap<Integer, Set<String>> zonesByOffset = new TreeMap<Integer, Set<String>>();

    Simple() {
    }

    @Override
    int processZoneinfo(Timezone timezone) {
        String string = timezone.getName();
        timezones.put(string, timezone);
        lastRules.put(string, timezone.getLastRules());
        lastZoneRecs.put(string, timezone.getLastZoneRec());
        int n = timezone.getRawOffset();
        TreeSet<String> treeSet = (TreeSet<String>)this.zonesByOffset.get(n);
        if (treeSet == null) {
            treeSet = new TreeSet<String>();
            this.zonesByOffset.put(n, treeSet);
        }
        treeSet.add(string);
        return 0;
    }

    @Override
    int generateSrc(Mappings mappings) {
        try {
            String string = Main.getOutputDir();
            File file = new File(string);
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            file.mkdirs();
            FileWriter fileWriter = new FileWriter(string + "TimeZoneData.java", false);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write("    // The following data is based on " + Main.getVersionName() + ".\n\n");
            bufferedWriter.write("    static final SimpleTimeZone zones[] = {\n");
            Map<String, String> map = mappings.getAliases();
            List<Integer> list = mappings.getRawOffsetsIndex();
            List<Set<String>> list2 = mappings.getRawOffsetsIndexTable();
            int n = 0;
            for (int n2 : this.zonesByOffset.keySet()) {
                int n3 = list.get(n);
                Set set = (Set)this.zonesByOffset.get(n2);
                if (n2 == n3) {
                    set.addAll((Collection)list2.get(n));
                    if (n2 == 3600000 && set.remove("MET")) {
                        Main.info("MET: removed for " + n2);
                    }
                }
                ++n;
                for (String string2 : set) {
                    Object object;
                    Timezone timezone;
                    ZoneRec zoneRec;
                    List<RuleRec> list3;
                    String string3;
                    if (!Zone.isTargetZone(string2)) continue;
                    String string4 = map.get(string2);
                    if (string4 != null) {
                        while ((string3 = map.get(string4)) != null) {
                            string4 = string3;
                        }
                        list3 = lastRules.get(string4);
                        zoneRec = lastZoneRecs.get(string4);
                        timezone = timezones.get(string4);
                    } else {
                        list3 = lastRules.get(string2);
                        zoneRec = lastZoneRecs.get(string2);
                        timezone = timezones.get(string2);
                    }
                    bufferedWriter.write("\t//--------------------------------------------------------------------\n");
                    if (timezone.isReviewRequired()) {
                        bufferedWriter.write("\t@@@Review required for \"" + string2 + "\"\n");
                    }
                    string3 = Time.toFormedString(n2);
                    bufferedWriter.write("\tnew SimpleTimeZone(" + Time.toFormedString(n2) + ", \"" + string2 + "\"");
                    if (string4 != null) {
                        bufferedWriter.write(" /* " + string4 + " */");
                    }
                    if (list3 == null) {
                        bufferedWriter.write("),\n");
                    } else {
                        object = list3.get(0);
                        RuleRec ruleRec = list3.get(1);
                        bufferedWriter.write(",\n\t  " + Month.toString(((RuleRec)object).getMonthNum()) + ", " + ((RuleRec)object).getDay().getDayForSimpleTimeZone() + ", " + ((RuleRec)object).getDay().getDayOfWeekForSimpleTimeZone() + ", " + Time.toFormedString((int)((RuleRec)object).getTime().getTime()) + ", " + ((RuleRec)object).getTime().getTypeForSimpleTimeZone() + ",\n\t  " + Month.toString(ruleRec.getMonthNum()) + ", " + ruleRec.getDay().getDayForSimpleTimeZone() + ", " + ruleRec.getDay().getDayOfWeekForSimpleTimeZone() + ", " + Time.toFormedString((int)ruleRec.getTime().getTime()) + ", " + ruleRec.getTime().getTypeForSimpleTimeZone() + ",\n\t  " + Time.toFormedString(((RuleRec)object).getSave()) + "),\n");
                        bufferedWriter.write("\t// " + ((RuleRec)object).getLine() + "\n");
                        bufferedWriter.write("\t// " + ruleRec.getLine() + "\n");
                    }
                    object = zoneRec.getLine();
                    if (((String)object).indexOf("Zone") == -1) {
                        object = "Zone " + string2 + "\t" + ((String)object).trim();
                    }
                    bufferedWriter.write("\t// " + (String)object + "\n");
                }
            }
            bufferedWriter.write("    };\n");
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (IOException iOException) {
            Main.panic("IO error: " + iOException.getMessage());
            return 1;
        }
        return 0;
    }
}

